/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.nio.charset.StandardCharsets;
import net.masterthought.cucumber.json.deserializers.EmbeddingDeserializer;
import org.codehaus.plexus.util.Base64;

@JsonDeserialize(using=EmbeddingDeserializer.class)
public class Embedding {
    private final String mimeType;
    private final String data;
    private final String fileId;

    public Embedding(String mimeType, String data) {
        this.mimeType = mimeType;
        this.data = data;
        this.fileId = "embedding_" + data.hashCode();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getData() {
        return this.data;
    }

    public String getDecodedData() {
        return new String(Base64.decodeBase64(this.data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public String getFileName() {
        return this.fileId + "." + this.getExtension();
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getExtension() {
        switch (this.mimeType) {
            case "image/png": 
            case "image/gif": 
            case "image/bmp": 
            case "image/jpeg": 
            case "text/html": 
            case "text/xml": 
            case "application/json": 
            case "application/xml": {
                return this.mimeType.substring(this.mimeType.indexOf(47) + 1);
            }
            case "image/url": {
                return "image";
            }
            case "text/plain": {
                return "txt";
            }
        }
        return "unknown";
    }
}

