/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.util.Arrays;
import net.masterthought.cucumber.Reportable;
import org.apache.commons.lang.ArrayUtils;

public class Trends {
    private String[] buildNumbers = new String[0];
    private int[] passedFeatures = new int[0];
    private int[] failedFeatures = new int[0];
    private int[] totalFeatures = new int[0];
    private int[] passedScenarios = new int[0];
    private int[] failedScenarios = new int[0];
    private int[] totalScenarios = new int[0];
    private int[] passedSteps = new int[0];
    private int[] failedSteps = new int[0];
    private int[] skippedSteps = new int[0];
    private int[] pendingSteps = new int[0];
    private int[] undefinedSteps = new int[0];
    private int[] totalSteps = new int[0];
    private long[] durations = new long[0];

    public String[] getBuildNumbers() {
        return this.buildNumbers;
    }

    public int[] getFailedFeatures() {
        return this.failedFeatures;
    }

    public int[] getPassedFeatures() {
        return this.passedFeatures;
    }

    public int[] getTotalFeatures() {
        return this.totalFeatures;
    }

    public int[] getPassedScenarios() {
        return this.passedScenarios;
    }

    public int[] getFailedScenarios() {
        return this.failedScenarios;
    }

    public int[] getTotalScenarios() {
        return this.totalScenarios;
    }

    public int[] getPassedSteps() {
        return this.passedSteps;
    }

    public int[] getFailedSteps() {
        return this.failedSteps;
    }

    public int[] getSkippedSteps() {
        return this.skippedSteps;
    }

    public int[] getPendingSteps() {
        return this.pendingSteps;
    }

    public int[] getUndefinedSteps() {
        return this.undefinedSteps;
    }

    public int[] getTotalSteps() {
        return this.totalSteps;
    }

    public long[] getDurations() {
        return this.durations;
    }

    public void addBuild(String buildNumber, Reportable reportable) {
        this.buildNumbers = (String[])ArrayUtils.add(this.buildNumbers, buildNumber);
        this.passedFeatures = ArrayUtils.add(this.passedFeatures, reportable.getPassedFeatures());
        this.failedFeatures = ArrayUtils.add(this.failedFeatures, reportable.getFailedFeatures());
        this.totalFeatures = ArrayUtils.add(this.totalFeatures, reportable.getFeatures());
        this.passedScenarios = ArrayUtils.add(this.passedScenarios, reportable.getPassedScenarios());
        this.failedScenarios = ArrayUtils.add(this.failedScenarios, reportable.getFailedScenarios());
        this.totalScenarios = ArrayUtils.add(this.totalScenarios, reportable.getScenarios());
        this.passedSteps = ArrayUtils.add(this.passedSteps, reportable.getPassedSteps());
        this.failedSteps = ArrayUtils.add(this.failedSteps, reportable.getFailedSteps());
        this.skippedSteps = ArrayUtils.add(this.skippedSteps, reportable.getSkippedSteps());
        this.pendingSteps = ArrayUtils.add(this.pendingSteps, reportable.getPendingSteps());
        this.undefinedSteps = ArrayUtils.add(this.undefinedSteps, reportable.getUndefinedSteps());
        this.totalSteps = ArrayUtils.add(this.totalSteps, reportable.getSteps());
        this.durations = ArrayUtils.add(this.durations, reportable.getDuration());
        this.applyPatchForFeatures();
        if (this.pendingSteps.length < this.buildNumbers.length) {
            this.fillMissingSteps();
        }
        if (this.durations.length < this.buildNumbers.length) {
            this.fillMissingDurations();
        }
    }

    public void limitItems(int limit) {
        this.buildNumbers = Trends.copyLastElements(this.buildNumbers, limit);
        this.passedFeatures = Trends.copyLastElements(this.passedFeatures, limit);
        this.failedFeatures = Trends.copyLastElements(this.failedFeatures, limit);
        this.totalFeatures = Trends.copyLastElements(this.totalFeatures, limit);
        this.passedScenarios = Trends.copyLastElements(this.passedScenarios, limit);
        this.failedScenarios = Trends.copyLastElements(this.failedScenarios, limit);
        this.totalScenarios = Trends.copyLastElements(this.totalScenarios, limit);
        this.passedSteps = Trends.copyLastElements(this.passedSteps, limit);
        this.failedSteps = Trends.copyLastElements(this.failedSteps, limit);
        this.skippedSteps = Trends.copyLastElements(this.skippedSteps, limit);
        this.pendingSteps = Trends.copyLastElements(this.pendingSteps, limit);
        this.undefinedSteps = Trends.copyLastElements(this.undefinedSteps, limit);
        this.totalSteps = Trends.copyLastElements(this.totalSteps, limit);
        this.durations = Trends.copyLastElements(this.durations, limit);
    }

    private static int[] copyLastElements(int[] srcArray, int copyingLimit) {
        if (srcArray.length <= copyingLimit) {
            return srcArray;
        }
        int[] dest = new int[copyingLimit];
        System.arraycopy(srcArray, srcArray.length - copyingLimit, dest, 0, copyingLimit);
        return dest;
    }

    private static long[] copyLastElements(long[] srcArray, int copyingLimit) {
        if (srcArray.length <= copyingLimit) {
            return srcArray;
        }
        long[] dest = new long[copyingLimit];
        System.arraycopy(srcArray, srcArray.length - copyingLimit, dest, 0, copyingLimit);
        return dest;
    }

    private static String[] copyLastElements(String[] srcArray, int copyingLimit) {
        if (srcArray.length <= copyingLimit) {
            return srcArray;
        }
        String[] dest = new String[copyingLimit];
        System.arraycopy(srcArray, srcArray.length - copyingLimit, dest, 0, copyingLimit);
        return dest;
    }

    private void applyPatchForFeatures() {
        for (int i = 0; i < this.totalFeatures.length; ++i) {
            int total = this.totalFeatures[i];
            int failures = this.getFailedFeatures()[i];
            if (total >= failures) continue;
            int tmp = total;
            this.totalFeatures[i] = failures;
            this.failedFeatures[i] = tmp;
        }
    }

    private void fillMissingSteps() {
        this.passedFeatures = this.fillMissingArray(this.passedFeatures);
        this.passedScenarios = this.fillMissingArray(this.passedScenarios);
        this.passedSteps = this.fillMissingArray(this.passedSteps);
        this.skippedSteps = this.fillMissingArray(this.skippedSteps);
        this.pendingSteps = this.fillMissingArray(this.pendingSteps);
        this.undefinedSteps = this.fillMissingArray(this.undefinedSteps);
    }

    private int[] fillMissingArray(int[] arrayToExtend) {
        int[] extendedArray = new int[this.buildNumbers.length];
        System.arraycopy(arrayToExtend, 0, extendedArray, this.buildNumbers.length - arrayToExtend.length, arrayToExtend.length);
        return extendedArray;
    }

    private void fillMissingDurations() {
        long[] extendedArray = new long[this.buildNumbers.length];
        Arrays.fill(extendedArray, -1L);
        System.arraycopy(this.durations, 0, extendedArray, this.buildNumbers.length - this.durations.length, this.durations.length);
        this.durations = extendedArray;
    }
}

