/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import java.util.List;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.genetic.Aspect;
import no.priv.garshol.duke.genetic.ComparatorAspect;
import no.priv.garshol.duke.genetic.HighProbabilityAspect;
import no.priv.garshol.duke.genetic.LowProbabilityAspect;
import no.priv.garshol.duke.genetic.ThresholdAspect;
import no.priv.garshol.duke.utils.ObjectUtils;

public class GeneticConfiguration
implements Comparable<GeneticConfiguration> {
    private GeneticConfiguration parent;
    private Configuration config;
    private List<Aspect> aspects;
    private double f;
    private int rank;
    private int mutation_rate;
    private double recombination_rate;

    public GeneticConfiguration(Configuration config) {
        this(config, -1, -1.0, true);
    }

    public GeneticConfiguration(Configuration config, int mutation_rate, double recombination_rate, boolean evolve_comparators) {
        this.config = config;
        List<Comparator> comparators = this.loadDefaultComparators();
        comparators.addAll(config.getCustomComparators());
        this.aspects = new ArrayList<Aspect>();
        this.aspects.add(new ThresholdAspect());
        for (Property prop : config.getProperties()) {
            if (prop.isIdProperty()) continue;
            if (evolve_comparators) {
                this.aspects.add(new ComparatorAspect(prop, comparators));
            }
            this.aspects.add(new LowProbabilityAspect(prop));
            this.aspects.add(new HighProbabilityAspect(prop));
        }
        if (mutation_rate == -1) {
            this.aspects.add(new MutationRateAspect());
        } else {
            this.mutation_rate = mutation_rate;
        }
        if (recombination_rate == -1.0) {
            this.aspects.add(new RecombinationRateAspect());
        } else {
            this.recombination_rate = recombination_rate;
        }
    }

    public GeneticConfiguration(GeneticConfiguration config) {
        this.parent = config;
        this.config = this.parent.getConfiguration().copy();
        this.aspects = this.parent.aspects;
        this.mutation_rate = config.getMutationRate();
        this.recombination_rate = config.getRecombinationRate();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public double getFNumber() {
        return this.f;
    }

    public void setFNumber(double f) {
        this.f = f;
    }

    public GeneticConfiguration getParent() {
        return this.parent;
    }

    public GeneticConfiguration makeRandomCopy() {
        GeneticConfiguration copy = new GeneticConfiguration(this);
        for (Aspect aspect : this.aspects) {
            aspect.setRandomly(copy);
        }
        return copy;
    }

    public GeneticConfiguration makeCopy() {
        GeneticConfiguration copy = new GeneticConfiguration(this);
        for (Aspect aspect : this.aspects) {
            if (!(aspect instanceof RecombinationRateAspect) && !(aspect instanceof MutationRateAspect)) continue;
            aspect.setRandomly(copy);
        }
        return copy;
    }

    public int getMutationRate() {
        return this.mutation_rate;
    }

    public void setMutationRate(int mutation_rate) {
        this.mutation_rate = mutation_rate;
    }

    public double getRecombinationRate() {
        return this.recombination_rate;
    }

    public void mutate() {
        Aspect aspect = this.aspects.get((int)(Math.random() * (double)this.aspects.size()));
        aspect.setRandomly(this);
    }

    public void mateWith(GeneticConfiguration other) {
        for (Aspect aspect : this.aspects) {
            if (!(Math.random() < 0.5)) continue;
            aspect.setFromOther(this, other);
        }
    }

    @Override
    public int compareTo(GeneticConfiguration other) {
        if (this.f < other.getFNumber()) {
            return 1;
        }
        if (this.f == other.getFNumber()) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[GeneticConfiguration " + GeneticConfiguration.shortnum(this.config.getThreshold()));
        for (Property p : this.config.getProperties()) {
            if (p.isIdProperty()) {
                buf.append(" [" + p.getName() + "]");
                continue;
            }
            buf.append(" [" + p.getName() + " " + this.shortname(p.getComparator()) + " " + GeneticConfiguration.shortnum(p.getHighProbability()) + " " + GeneticConfiguration.shortnum(p.getLowProbability()) + "]");
        }
        buf.append(" mr=" + this.mutation_rate + " rr=" + GeneticConfiguration.shortnum(this.recombination_rate));
        buf.append("]");
        return buf.toString();
    }

    private String shortname(Comparator comp) {
        return comp.getClass().getSimpleName();
    }

    static String shortnum(double number) {
        String str = "" + number;
        if (str.length() > 4) {
            return str.substring(0, 4);
        }
        return str;
    }

    private List<Comparator> loadDefaultComparators() {
        String PKG = "no.priv.garshol.duke.comparators.";
        String[] compnames = new String[]{"DiceCoefficientComparator", "DifferentComparator", "ExactComparator", "JaroWinkler", "JaroWinklerTokenized", "Levenshtein", "NumericComparator", "PersonNameComparator", "SoundexComparator", "WeightedLevenshtein", "NorphoneComparator", "MetaphoneComparator", "QGramComparator", "GeopositionComparator", "LongestCommonSubstring"};
        ArrayList<Comparator> comparators = new ArrayList<Comparator>();
        for (int ix = 0; ix < compnames.length; ++ix) {
            comparators.add((Comparator)ObjectUtils.instantiate(PKG + compnames[ix]));
        }
        return comparators;
    }

    static class RecombinationRateAspect
    extends Aspect {
        RecombinationRateAspect() {
        }

        @Override
        public void setRandomly(GeneticConfiguration config) {
            config.recombination_rate = Math.random() * 5.0;
        }

        @Override
        public void setFromOther(GeneticConfiguration config, GeneticConfiguration other) {
            config.recombination_rate = other.recombination_rate;
        }
    }

    static class MutationRateAspect
    extends Aspect {
        MutationRateAspect() {
        }

        @Override
        public void setRandomly(GeneticConfiguration config) {
            config.mutation_rate = 1 + (int)(Math.random() * 10.0);
        }

        @Override
        public void setFromOther(GeneticConfiguration config, GeneticConfiguration other) {
            config.mutation_rate = other.mutation_rate;
        }
    }
}

