/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.InMemoryLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.genetic.ConsoleOracle;
import no.priv.garshol.duke.genetic.ExemplarsTracker;
import no.priv.garshol.duke.genetic.GeneticConfiguration;
import no.priv.garshol.duke.genetic.GeneticPopulation;
import no.priv.garshol.duke.genetic.LinkFileOracle;
import no.priv.garshol.duke.genetic.Oracle;
import no.priv.garshol.duke.genetic.Pair;
import no.priv.garshol.duke.matchers.MatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;
import no.priv.garshol.duke.matchers.TestFileListener;
import no.priv.garshol.duke.utils.LinkDatabaseUtils;

public class GeneticAlgorithm {
    private Configuration config;
    private GeneticPopulation population;
    private Database database;
    private Map<String, Record> secondary;
    private InMemoryLinkDatabase testdb;
    private double best;
    private boolean active;
    private boolean scientific;
    private Oracle oracle;
    private String outfile;
    private Map<GeneticConfiguration, Double> sciencetracker;
    private boolean quiet;
    private boolean incomplete;
    private int threads;
    private int generations;
    private int questions;
    private boolean sparse;
    private int skipgens;
    private int asked;
    private Collection<Pair> used;

    public GeneticAlgorithm(Configuration config, String testfile, boolean scientific) throws IOException {
        this.config = config;
        this.population = new GeneticPopulation(config);
        this.generations = 100;
        this.questions = 10;
        this.testdb = new InMemoryLinkDatabase();
        this.scientific = scientific;
        this.threads = 1;
        this.used = new ArrayList<Pair>();
        if (!scientific) {
            this.oracle = new ConsoleOracle();
            if (testfile != null) {
                LinkDatabaseUtils.loadTestFile(testfile, (LinkDatabase)this.testdb);
            } else {
                this.active = true;
            }
        } else {
            this.active = true;
            this.oracle = new LinkFileOracle(testfile);
            this.sciencetracker = Collections.synchronizedMap(new HashMap());
        }
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public void setPopulation(int population) {
        this.population.setSize(population);
    }

    public void setQuestions(int questions) {
        this.questions = questions;
    }

    public void setConfigOutput(String output) {
        this.outfile = output;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSparse(boolean sparse) {
        this.sparse = sparse;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setLinkFile(String linkfile) throws IOException {
        if (this.scientific || !this.active || this.oracle instanceof LinkFileOracle) {
            throw new DukeConfigException("Have no use for link file");
        }
        ((ConsoleOracle)this.oracle).setLinkFile(linkfile);
    }

    public void setMutationRate(int mutation_rate) {
        this.population.setMutationRate(mutation_rate);
    }

    public void setRecombinationRate(double recombination_rate) {
        this.population.setRecombinationRate(recombination_rate);
    }

    public void setEvolveComparators(boolean evolve_comparators) {
        this.population.setEvolveComparators(evolve_comparators);
    }

    public void setCopiesOfOriginal(int copies) {
        this.population.setCopiesOfOriginal(copies);
    }

    public void setIncompleteTest(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public void run() {
        RecordIterator it;
        Collection<DataSource> sources = this.config.isDeduplicationMode() ? this.config.getDataSources() : this.config.getDataSources(1);
        this.database = this.config.getDatabase(true);
        for (DataSource src : sources) {
            it = src.getRecords();
            while (it.hasNext()) {
                this.database.index((Record)it.next());
            }
        }
        this.database.commit();
        if (!this.config.isDeduplicationMode() && this.active) {
            this.secondary = new HashMap<String, Record>();
            for (DataSource src : this.config.getDataSources(2)) {
                it = src.getRecords();
                while (it.hasNext()) {
                    Record r = (Record)it.next();
                    this.secondary.put(this.getid(r), r);
                }
            }
        }
        this.population.create();
        double prevbest = 0.0;
        boolean stuck_for = false;
        for (int gen = 0; gen < this.generations; ++gen) {
            if (!this.quiet) {
                System.out.println("===== GENERATION " + gen);
            }
            double d = this.evolve(gen);
        }
    }

    public double evolve(int gen_no) {
        ExemplarsTracker tracker = null;
        if (this.active) {
            Comparator<Pair> comparator = gen_no == 0 ? new FindCorrectComparator() : new DisagreementComparator();
            tracker = new ExemplarsTracker(this.config, comparator);
        }
        if (this.threads == 1) {
            this.evaluateAll(tracker);
        } else {
            this.evaluateAllThreaded(tracker);
        }
        this.population.sort();
        double fsum = 0.0;
        double lbest = -1.0;
        GeneticConfiguration best = null;
        List<GeneticConfiguration> pop = this.population.getConfigs();
        for (GeneticConfiguration cfg : pop) {
            fsum += cfg.getFNumber();
            if (!(cfg.getFNumber() > lbest)) continue;
            lbest = cfg.getFNumber();
            best = cfg;
        }
        if (!this.quiet) {
            System.out.println("BEST: " + lbest + " AVERAGE: " + fsum / (double)pop.size());
            for (GeneticConfiguration cfg : pop) {
                System.out.print(cfg.getFNumber() + " ");
            }
            System.out.println();
        }
        if (this.active && this.skipgens == 0) {
            this.askQuestions(tracker);
            if (this.sparse) {
                if (gen_no > 9) {
                    this.skipgens = 3;
                } else if (gen_no > 1) {
                    this.skipgens = 1;
                }
            }
        } else if (this.skipgens > 0) {
            --this.skipgens;
        }
        if (this.scientific) {
            double devsum = 0.0;
            fsum = 0.0;
            lbest = -1.0;
            for (GeneticConfiguration cfg : pop) {
                double real = this.sciencetracker.get(cfg);
                devsum += Math.abs(cfg.getFNumber() - real);
                fsum += real;
                if (!(real > lbest)) continue;
                lbest = real;
            }
            if (!this.quiet) {
                System.out.println("ACTUAL BEST: " + this.sciencetracker.get(best) + " ACTUAL AVERAGE: " + fsum / (double)pop.size());
                System.out.println("AVERAGE DEVIATION: " + devsum / (double)pop.size());
                System.out.println("QUESTIONS ASKED: " + this.used.size());
                System.out.println();
            }
            this.sciencetracker.clear();
        }
        if (this.outfile != null) {
            try {
                Configuration b = this.population.getBestConfiguration().getConfiguration();
                FileOutputStream fos = new FileOutputStream(this.outfile);
                ConfigWriter configWriter = new ConfigWriter(fos);
                configWriter.write(b);
                fos.close();
            }
            catch (IOException e) {
                System.err.println("ERROR: Cannot write to '" + this.outfile + "': " + e);
            }
        }
        if (this.active && this.population.getBestConfiguration().getFNumber() == this.population.getWorstConfiguration().getFNumber()) {
            return lbest;
        }
        this.produceNextGeneration();
        return lbest;
    }

    private void produceNextGeneration() {
        List<GeneticConfiguration> pop = this.population.getConfigs();
        int size = pop.size();
        ArrayList<GeneticConfiguration> nextgen = new ArrayList<GeneticConfiguration>(size);
        for (GeneticConfiguration geneticConfiguration : pop.subList(0, (int)((double)size * 0.02))) {
            nextgen.add(new GeneticConfiguration(geneticConfiguration));
        }
        for (GeneticConfiguration geneticConfiguration : pop.subList(0, (int)((double)size * 0.03))) {
            nextgen.add(new GeneticConfiguration(geneticConfiguration));
        }
        int start = (int)((double)size * 0.25);
        for (GeneticConfiguration cfg : pop.subList(0, start)) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        for (GeneticConfiguration cfg : pop.subList(0, start)) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        int n = pop.size() - nextgen.size();
        for (GeneticConfiguration cfg : pop.subList(start, start + n)) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        if (nextgen.size() > size) {
            nextgen = nextgen.subList(0, size);
        }
        for (GeneticConfiguration cfg : nextgen) {
            for (double rr = cfg.getRecombinationRate(); rr > Math.random(); rr -= 1.0) {
                cfg.mateWith(this.population.pickRandomConfig());
            }
            for (int ix = 0; ix < cfg.getMutationRate(); ++ix) {
                cfg.mutate();
            }
        }
        this.population.setNewGeneration(nextgen);
    }

    private void evaluateAll(ExemplarsTracker tracker) {
        List<GeneticConfiguration> pop = this.population.getConfigs();
        for (GeneticConfiguration cfg : pop) {
            if (!this.quiet) {
                System.out.println(cfg);
            }
            double f = this.evaluate(cfg, tracker);
            if (!this.quiet) {
                System.out.print("  " + f);
            }
            if (f > this.best) {
                if (!this.quiet) {
                    System.out.println("\nNEW BEST! " + f + "\n");
                }
                this.best = f;
            }
            if (this.quiet) continue;
            if (this.scientific) {
                System.out.println("  (actual: " + this.sciencetracker.get(cfg) + ")");
                continue;
            }
            System.out.println();
        }
    }

    private void evaluateAllThreaded(ExemplarsTracker tracker) {
        int ix;
        WorkManager mgr = new WorkManager(this.population.getConfigs());
        WorkerThread[] workers = new WorkerThread[this.threads];
        for (ix = 0; ix < this.threads; ++ix) {
            workers[ix] = new WorkerThread(tracker, mgr, ix);
            workers[ix].start();
        }
        try {
            for (ix = 0; ix < workers.length; ++ix) {
                workers[ix].join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private double evaluate(GeneticConfiguration config, MatchListener listener) {
        Configuration cconfig = config.getConfiguration();
        Processor proc = new Processor(cconfig, this.database);
        TestFileListener eval = this.makeEval(cconfig, this.testdb, proc);
        if (this.active || this.incomplete) {
            eval.setPessimistic(false);
        }
        proc.addMatchListener(eval);
        TestFileListener seval = null;
        if (this.scientific) {
            seval = this.makeEval(cconfig, ((LinkFileOracle)this.oracle).getLinkDatabase(), proc);
            seval.setPessimistic(true);
            proc.addMatchListener(seval);
        }
        if (listener != null) {
            proc.addMatchListener(listener);
        }
        if (cconfig.isDeduplicationMode()) {
            proc.linkRecords(cconfig.getDataSources());
        } else {
            proc.linkRecords(cconfig.getDataSources(2), false);
        }
        if (seval != null) {
            this.sciencetracker.put(config, seval.getFNumber());
        }
        config.setFNumber(eval.getFNumber());
        return eval.getFNumber();
    }

    private TestFileListener makeEval(Configuration cfg, LinkDatabase testdb, Processor proc) {
        TestFileListener eval = new TestFileListener(testdb, cfg, false, proc, false, false);
        eval.setQuiet(true);
        return eval;
    }

    public GeneticConfiguration getBestConfiguration() {
        return this.population.getBestConfiguration();
    }

    public GeneticPopulation getPopulation() {
        return this.population;
    }

    private void askQuestions(ExemplarsTracker tracker) {
        Pair pair;
        int count = 0;
        Filter f = new Filter(tracker.getExemplars());
        while ((pair = f.getNext()) != null) {
            Record r1 = this.database.findRecordById(pair.id1);
            if (r1 == null) {
                r1 = this.secondary.get(pair.id1);
            }
            Record r2 = this.database.findRecordById(pair.id2);
            System.out.println();
            PrintMatchListener.prettyCompare(r1, r2, pair.counter, "Possible match", this.config.getProperties());
            LinkKind kind = this.oracle.getLinkKind(pair.id1, pair.id2);
            Link link = new Link(pair.id1, pair.id2, LinkStatus.ASSERTED, kind, 1.0);
            this.testdb.assertLink(link);
            if (++count != this.questions) continue;
            break;
        }
        this.asked += count;
    }

    private String getid(Record r) {
        for (String propname : r.getProperties()) {
            Property prop = this.config.getPropertyByName(propname);
            if (prop == null) {
                throw new DukeConfigException("Record has property " + propname + " which is not in configuration");
            }
            if (!prop.isIdProperty()) continue;
            return r.getValue(propname);
        }
        return null;
    }

    class WorkerThread
    extends Thread {
        private WorkManager mgr;
        private ExemplarsTracker tracker;

        public WorkerThread(ExemplarsTracker tracker, WorkManager mgr, int threadno) {
            super("WorkerThread " + threadno);
            this.mgr = mgr;
            this.tracker = tracker;
        }

        @Override
        public void run() {
            GeneticConfiguration cfg = this.mgr.getNextConfig();
            while (cfg != null) {
                GeneticAlgorithm.this.evaluate(cfg, this.tracker);
                this.mgr.evaluated(cfg);
                cfg = this.mgr.getNextConfig();
            }
        }
    }

    class WorkManager {
        private List<GeneticConfiguration> pop;
        private int next;

        public WorkManager(List<GeneticConfiguration> pop) {
            this.pop = pop;
        }

        public synchronized GeneticConfiguration getNextConfig() {
            if (this.next < this.pop.size()) {
                return this.pop.get(this.next++);
            }
            return null;
        }

        public synchronized void evaluated(GeneticConfiguration cfg) {
            double f = cfg.getFNumber();
            if (!GeneticAlgorithm.this.quiet) {
                System.out.println(cfg);
                System.out.print("  " + f);
            }
            if (f > GeneticAlgorithm.this.best) {
                if (!GeneticAlgorithm.this.quiet) {
                    System.out.println("\nNEW BEST! " + f + "\n");
                }
                GeneticAlgorithm.this.best = f;
            }
            if (!GeneticAlgorithm.this.quiet) {
                if (GeneticAlgorithm.this.scientific) {
                    System.out.println("  (actual: " + GeneticAlgorithm.this.sciencetracker.get(cfg) + ")");
                } else {
                    System.out.println();
                }
            }
        }
    }

    class DisagreementComparator
    implements Comparator<Pair> {
        DisagreementComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            int size = GeneticAlgorithm.this.population.size();
            return this.getScore(p2) - this.getScore(p1);
        }

        private int getScore(Pair pair) {
            int size = GeneticAlgorithm.this.population.size();
            return (size - pair.counter) * (size - (size - pair.counter));
        }
    }

    static class FindCorrectComparator
    implements Comparator<Pair> {
        FindCorrectComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            return p2.counter - p1.counter;
        }
    }

    class Filter {
        private List<Pair> exemplars;

        public Filter(List<Pair> exemplars) {
            this.exemplars = exemplars;
            this.applyFilter();
        }

        public Pair getNext() {
            if (this.exemplars.isEmpty()) {
                return null;
            }
            double bestscore = 2.0;
            Pair thebest = this.exemplars.get(0);
            for (Pair candidate : this.exemplars) {
                if (GeneticAlgorithm.this.testdb.inferLink(candidate.id1, candidate.id2) != null) continue;
                double worst = 0.0;
                for (Pair seen : GeneticAlgorithm.this.used) {
                    double score = this.compare(candidate, seen);
                    if (!(score > worst)) continue;
                    worst = score;
                }
                if (!(worst < bestscore)) continue;
                bestscore = worst;
                thebest = candidate;
            }
            GeneticAlgorithm.this.used.add(thebest);
            this.exemplars.remove(thebest);
            return thebest;
        }

        private void applyFilter() {
            ArrayList<Pair> chosen = new ArrayList<Pair>();
            for (int next = 0; chosen.size() < GeneticAlgorithm.this.questions * 2 && next < this.exemplars.size(); ++next) {
                Pair pair = this.exemplars.get(next);
                if (GeneticAlgorithm.this.testdb.inferLink(pair.id1, pair.id2) != null) continue;
                pair.believers = this.whoThinksThisIsTrue(pair.id1, pair.id2);
                chosen.add(pair);
            }
            this.exemplars = chosen;
        }

        private double compare(Pair p1, Pair p2) {
            int intersection = 0;
            int union = 0;
            for (int ix = 0; ix < p1.believers.length; ++ix) {
                if (p1.believers[ix] && p2.believers[ix]) {
                    ++intersection;
                }
                if (!p1.believers[ix] && !p2.believers[ix]) continue;
                ++union;
            }
            return (double)intersection / (double)union;
        }

        private boolean[] whoThinksThisIsTrue(String id1, String id2) {
            Record r2;
            Record r1 = GeneticAlgorithm.this.database.findRecordById(id1);
            if (r1 == null) {
                r1 = (Record)GeneticAlgorithm.this.secondary.get(id1);
            }
            if ((r2 = GeneticAlgorithm.this.database.findRecordById(id2)) == null) {
                r2 = (Record)GeneticAlgorithm.this.secondary.get(id2);
            }
            List<GeneticConfiguration> configs = GeneticAlgorithm.this.population.getConfigs();
            boolean[] believers = new boolean[configs.size()];
            for (int ix = 0; ix < configs.size(); ++ix) {
                Configuration config = configs.get(ix).getConfiguration();
                Processor proc = new Processor(config, GeneticAlgorithm.this.database);
                believers[ix] = proc.compare(r1, r2) > config.getThreshold();
            }
            return believers;
        }
    }
}

