/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import java.util.HashSet;
import java.util.Set;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.DukeConfigException;

public class QGramComparator
implements Comparator {
    private Formula formula = Formula.OVERLAP;
    private Tokenizer tokenizer = Tokenizer.BASIC;
    private int q = 2;

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return 1.0;
        }
        Set<String> q1 = this.tokenizer.qgrams(s1, this.q);
        Set<String> q2 = this.tokenizer.qgrams(s2, this.q);
        if (q1.isEmpty() || q2.isEmpty()) {
            return 0.0;
        }
        int common = 0;
        for (String gram : q1) {
            if (!q2.contains(gram)) continue;
            ++common;
        }
        return this.formula.compute(common, q1, q2);
    }

    public void setQ(int q) {
        this.q = q;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    private static String pad(String s, int q, boolean front) {
        StringBuffer buf = new StringBuffer(q);
        if (!front) {
            buf.append(s);
        }
        for (int ix = 0; ix < q - s.length(); ++ix) {
            buf.append('.');
        }
        if (front) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static enum Tokenizer {
        BASIC{

            @Override
            public Set<String> qgrams(String s, int q) {
                HashSet<String> grams = new HashSet<String>();
                for (int ix = 0; ix < s.length() - q + 1; ++ix) {
                    grams.add(s.substring(ix, ix + q));
                }
                return grams;
            }
        }
        ,
        POSITIONAL{

            @Override
            public Set<String> qgrams(String s, int q) {
                HashSet<String> grams = new HashSet<String>();
                for (int ix = 0; ix < s.length() - q + 1; ++ix) {
                    grams.add(s.substring(ix, ix + q) + ix);
                }
                return grams;
            }
        }
        ,
        ENDS{

            @Override
            public Set<String> qgrams(String s, int q) {
                int ix;
                HashSet<String> grams = new HashSet<String>();
                for (ix = 1; ix < q; ++ix) {
                    grams.add(QGramComparator.pad(s.substring(0, ix), q, true));
                }
                for (ix = 0; ix < s.length() - q + 1; ++ix) {
                    grams.add(s.substring(ix, ix + q));
                }
                for (ix = 1; ix < q; ++ix) {
                    grams.add(QGramComparator.pad(s.substring(s.length() - ix), q, false));
                }
                return grams;
            }
        };


        public Set<String> qgrams(String s, int q) {
            throw new DukeConfigException("Uknown tokenizer: " + (Object)((Object)this));
        }
    }

    public static enum Formula {
        OVERLAP{

            @Override
            public double compute(int common, Set<String> q1, Set<String> q2) {
                return (double)common / Math.min((double)q1.size(), (double)q2.size());
            }
        }
        ,
        JACCARD{

            @Override
            public double compute(int common, Set<String> q1, Set<String> q2) {
                return (double)common / (double)(q1.size() + q2.size() - common);
            }
        }
        ,
        DICE{

            @Override
            public double compute(int common, Set<String> q1, Set<String> q2) {
                return 2.0 * (double)common / (double)(q1.size() + q2.size());
            }
        };


        public double compute(int common, Set<String> q1, Set<String> q2) {
            throw new DukeConfigException("Unknown formula: " + (Object)((Object)this));
        }
    }
}

