/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.comparators.ExactComparator;
import no.priv.garshol.duke.utils.StringUtils;

public class DiceCoefficientComparator
implements Comparator {
    private Comparator subcomp = new ExactComparator();

    public void setComparator(Comparator comp) {
        this.subcomp = comp;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String s1, String s2) {
        String[] t2;
        if (s1.equals(s2)) {
            return 1.0;
        }
        String[] t1 = StringUtils.split(s1);
        if (t1.length > (t2 = StringUtils.split(s2)).length) {
            String[] tmp = t2;
            t2 = t1;
            t1 = tmp;
        }
        double sum = 0.0;
        for (int ix1 = 0; ix1 < t1.length; ++ix1) {
            double highest = 0.0;
            for (int ix2 = 0; ix2 < t2.length; ++ix2) {
                highest = Math.max(highest, this.subcomp.compare(t1[ix1], t2[ix2]));
            }
            sum += highest;
        }
        return sum * 2.0 / (double)(t1.length + t2.length);
    }
}

