/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.cleaners.DigitsOnlyCleaner;

public class PhoneNumberCleaner
implements Cleaner {
    private Cleaner sub = new DigitsOnlyCleaner();
    private static Map<String, CountryCode> ccodes = PhoneNumberCleaner.initcodes();

    @Override
    public String clean(String value) {
        CountryCode ccode;
        boolean zerozero;
        String orig = value;
        boolean initialplus = this.findPlus(value);
        if ((value = this.sub.clean(value)) == null) {
            return null;
        }
        boolean bl = zerozero = !initialplus && value.startsWith("00");
        if (zerozero) {
            value = value.substring(2);
        }
        if ((ccode = this.findCountryCode(value)) == null) {
            if (initialplus || zerozero) {
                return orig;
            }
            return value;
        }
        value = value.substring(ccode.getPrefix().length());
        if (ccode.getStripZero() && value.startsWith("0")) {
            value = value.substring(1);
        }
        if (ccode.isRightFormat(value)) {
            return "+" + ccode.getPrefix() + " " + value;
        }
        return orig;
    }

    private CountryCode findCountryCode(String value) {
        for (int ix = 1; ix < Math.min(4, value.length()); ++ix) {
            String code = value.substring(0, ix);
            CountryCode ccode = ccodes.get(code);
            if (ccode == null) continue;
            return ccode;
        }
        return null;
    }

    private boolean findPlus(String value) {
        for (int ix = 0; ix < value.length(); ++ix) {
            char ch = value.charAt(ix);
            if (ch == '+') {
                return true;
            }
            if (ch < '0' || ch > '9') continue;
            return false;
        }
        return false;
    }

    private static Map<String, CountryCode> initcodes() {
        HashMap<String, CountryCode> ccs = new HashMap<String, CountryCode>();
        ccs.put("1", new CountryCode("1", false, 10));
        ccs.put("31", new CountryCode("31"));
        ccs.put("33", new CountryCode("33"));
        ccs.put("358", new CountryCode("358"));
        ccs.put("44", new CountryCode("44", true));
        ccs.put("45", new CountryCode("45", 8));
        ccs.put("46", new CountryCode("46", true, 7, 9));
        ccs.put("47", new CountryCode("47", true, 8));
        ccs.put("49", new CountryCode("49"));
        ccs.put("971", new CountryCode("971", true, 7, 9));
        return ccs;
    }

    static class CountryCode {
        private String prefix;
        private boolean strip_zero;
        private int min_length;
        private int max_length;

        public CountryCode(String prefix) {
            this(prefix, false);
        }

        public CountryCode(String prefix, int length) {
            this(prefix, false, length);
        }

        public CountryCode(String prefix, boolean strip_zero) {
            this(prefix, strip_zero, 0);
        }

        public CountryCode(String prefix, boolean strip_zero, int length) {
            this.prefix = prefix;
            this.strip_zero = strip_zero;
            this.min_length = length;
            this.max_length = length;
        }

        public CountryCode(String prefix, boolean strip_zero, int min_length, int max_length) {
            this.prefix = prefix;
            this.strip_zero = strip_zero;
            this.min_length = min_length;
            this.max_length = max_length;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean getStripZero() {
            return this.strip_zero;
        }

        public boolean isRightFormat(String value) {
            if (this.max_length == 0) {
                return true;
            }
            return value.length() >= this.min_length && value.length() <= this.max_length;
        }
    }
}

