/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;

public class InMemoryLinkDatabase
implements LinkDatabase {
    private Map<String, Collection<Link>> links = new HashMap<String, Collection<Link>>();
    private boolean infer;

    public void setDoInference(boolean infer) {
        this.infer = infer;
    }

    public List<Link> getAllLinks() {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<Link> all = new ArrayList<Link>();
        for (Collection<Link> linkcoll : this.links.values()) {
            for (Link link : linkcoll) {
                String id = link.getID1() + ',' + link.getID2();
                if (seen.contains(id)) continue;
                all.add(link);
                seen.add(id);
            }
        }
        return all;
    }

    public List<Link> getChangesSince(long since) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Link> getAllLinksFor(String id) {
        Collection<Link> l = this.links.get(id);
        if (l == null) {
            return Collections.EMPTY_SET;
        }
        return l;
    }

    @Override
    public void assertLink(Link link) {
        boolean found = false;
        Collection<Link> linkset = this.links.get(link.getID1());
        if (linkset != null) {
            for (Link oldlink : linkset) {
                if (!oldlink.equals(link)) continue;
                this.retract(oldlink);
                found = true;
                break;
            }
        }
        if (!found && this.infer) {
            if (link.getKind() == LinkKind.SAME) {
                this.copyall(link.getID1(), link.getID2());
                this.copyall(link.getID2(), link.getID1());
            } else if (link.getKind() == LinkKind.DIFFERENT) {
                Collection<String> klass = this.getClass(link.getID1());
                for (String id : klass) {
                    this.addLink2(new Link(id, link.getID2(), link.getStatus(), LinkKind.DIFFERENT, link.getConfidence()));
                }
                klass = this.getClass(link.getID2());
                for (String id : klass) {
                    this.addLink2(new Link(id, link.getID1(), link.getStatus(), LinkKind.DIFFERENT, link.getConfidence()));
                }
            }
            this.addLink2(link);
        } else {
            this.addLink(link);
        }
    }

    private void copyall(String id1, String id2) {
        Collection<String> class1 = this.getClass(id1);
        for (String id : class1) {
            for (Link tocopy : this.getAllLinksFor(id2)) {
                String other = tocopy.getOtherId(id2);
                if (id.equals(other)) continue;
                this.addLink2(new Link(id, other, tocopy.getStatus(), tocopy.getKind(), tocopy.getConfidence()));
            }
        }
    }

    private void addLink(Link link) {
        this.indexLink(link.getID1(), link);
        this.indexLink(link.getID2(), link);
    }

    private void addLink2(Link link) {
        boolean found = false;
        Collection<Link> linkset = this.links.get(link.getID1());
        if (linkset != null) {
            for (Link oldlink : linkset) {
                if (!oldlink.equals(link)) continue;
                return;
            }
        }
        this.addLink(link);
    }

    private Collection<String> getClass(String id) {
        ArrayList<String> klass = new ArrayList<String>();
        klass.add(id);
        for (Link link : this.getAllLinksFor(id)) {
            if (link.getKind() != LinkKind.SAME) continue;
            klass.add(link.getOtherId(id));
        }
        return klass;
    }

    private void retract(Link link) {
        this.links.get(link.getID1()).remove(link);
        this.links.get(link.getID2()).remove(link);
    }

    private void indexLink(String id, Link link) {
        Collection<Link> ourlinks = this.links.get(id);
        if (ourlinks == null) {
            ourlinks = new ArrayList<Link>();
            this.links.put(id, ourlinks);
        }
        ourlinks.add(link);
    }

    @Override
    public Link inferLink(String id1, String id2) {
        Collection<Link> ourlinks = this.links.get(id1);
        if (ourlinks != null) {
            for (Link link : ourlinks) {
                if (!link.getID1().equals(id2) && !link.getID2().equals(id2)) continue;
                return link;
            }
        }
        return null;
    }

    private boolean traverseFrom(String id, String goalid, Set<String> seen) {
        seen.add(id);
        if (this.links.get(id) == null) {
            return false;
        }
        for (Link link : this.links.get(id)) {
            if (link.getKind() != LinkKind.SAME) continue;
            String otherid = link.getID1();
            if (otherid.equals(id)) {
                otherid = link.getID2();
            }
            if (otherid.equals(goalid)) {
                return true;
            }
            if (seen.contains(otherid) || !this.traverseFrom(otherid, goalid, seen)) continue;
            return true;
        }
        return false;
    }

    public void checkConsistency() {
        for (String id : this.links.keySet()) {
            HashSet<String> diff = new HashSet<String>();
            for (Link link : this.links.get(id)) {
                if (link.getKind() != LinkKind.DIFFERENT) continue;
                diff.add(link.getOtherId(id));
            }
            for (String eqid : this.traverseAll(id, new HashSet<String>())) {
                if (!diff.contains(eqid)) continue;
                System.out.println("Inconsistency: " + id + " <-> " + eqid);
            }
        }
    }

    public Set<String> traverseAll(String id, Set<String> seen) {
        seen.add(id);
        for (Link link : this.links.get(id)) {
            String other = link.getOtherId(id);
            if (link.getKind() != LinkKind.SAME || seen.contains(other)) continue;
            this.traverseAll(other, seen);
        }
        return seen;
    }

    @Override
    public void validateConnection() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void clear() {
        this.links.clear();
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "[InMemoryLinkDatabase size: " + this.getAllLinks().size() + " infer: " + this.infer + " " + this.hashCode() + "]";
    }
}

