/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.RecordBuilder;

public class JsonDataSource
extends ColumnarDataSource {
    private String file;

    public String getInputFile() {
        return this.file;
    }

    public void setInputFile(String file) {
        this.file = file;
    }

    public RecordIterator getRecordsFromString(String s) {
        try {
            JsonFactory jsonFactory = new JsonFactory();
            return new JsonIterator(jsonFactory.createParser((Reader)new StringReader(s)));
        }
        catch (IOException e) {
            throw new DukeException((Throwable)e);
        }
    }

    public RecordIterator getRecordsFromStream(InputStream is) {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            JsonParser jp = jsonFactory.createParser(is);
            return new JsonIterator(jp);
        }
        catch (IOException e) {
            throw new DukeException((Throwable)e);
        }
    }

    public RecordIterator getRecords() {
        try {
            return this.getRecordsFromStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new DukeException("Error reading JSON from " + this.file, (Throwable)e);
        }
    }

    public void writeConfig(ConfigWriter cw) {
        String name = "json";
        cw.writeStartElement("json", null);
        this.writeColumnsConfig(cw);
        cw.writeEndElement("json");
    }

    public String getSourceName() {
        return "JSON";
    }

    protected class JsonIterator
    extends RecordIterator {
        private JsonParser parser;
        private RecordBuilder builder;
        private Map<String, Set<Column>> cols = new HashMap<String, Set<Column>>();
        private JsonToken tokenFromHasNext;

        public JsonIterator(JsonParser jp) {
            this.parser = jp;
            this.builder = new RecordBuilder((ColumnarDataSource)JsonDataSource.this);
            for (Column col : JsonDataSource.this.getColumns()) {
                if (this.cols.containsKey(col.getName())) {
                    this.cols.get(col.getName()).add(col);
                    continue;
                }
                this.cols.put(col.getName(), new HashSet<Column>(Arrays.asList(col)));
            }
        }

        public boolean hasNext() {
            try {
                this.tokenFromHasNext = this.parser.nextToken();
                return this.tokenFromHasNext == JsonToken.START_OBJECT;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        public Record next() {
            this.builder.newRecord();
            Set<Column> currentCols = null;
            try {
                JsonToken currentToken;
                int nestingLevel = -1;
                do {
                    if (this.tokenFromHasNext == null) {
                        currentToken = this.parser.nextToken();
                    } else {
                        currentToken = this.tokenFromHasNext;
                        this.tokenFromHasNext = null;
                    }
                    if (currentToken == JsonToken.START_OBJECT) {
                        ++nestingLevel;
                        continue;
                    }
                    if (currentToken == JsonToken.END_OBJECT) {
                        --nestingLevel;
                        continue;
                    }
                    if (currentToken == JsonToken.FIELD_NAME) {
                        currentCols = this.cols.get(this.parser.getCurrentName());
                        continue;
                    }
                    if (currentToken == JsonToken.END_ARRAY || currentCols == null || currentToken == JsonToken.START_ARRAY || currentToken == JsonToken.END_ARRAY) continue;
                    for (Column currentCol : currentCols) {
                        this.builder.addValue(currentCol, this.parser.getText());
                    }
                } while (currentToken != JsonToken.END_OBJECT || nestingLevel != -1);
            }
            catch (IOException e) {
                throw new DukeException((Throwable)e);
            }
            return this.builder.getRecord();
        }
    }
}

