/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.cleaners.FamilyCommaGivenCleaner;
import no.priv.garshol.duke.cleaners.RegexpCleaner;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.NTriplesDataSource;
import org.junit.Before;
import org.junit.Test;

public class NTriplesDataSourceTest {
    private NTriplesDataSource source;
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

    @Before
    public void setup() {
        this.source = new NTriplesDataSource();
    }

    @Test
    public void testEmpty() {
        RecordIterator it = this.read("");
        Assert.assertFalse((String)"empty data source contains records", (boolean)it.hasNext());
    }

    @Test
    public void testEmptyIncremental() {
        this.source.setIncrementalMode(true);
        this.testEmpty();
    }

    @Test
    public void testEmptyBlank() {
        RecordIterator it = this.read("\n\n");
        Assert.assertFalse((String)"empty data source contains records", (boolean)it.hasNext());
    }

    @Test
    public void testEmptyBlankInc() {
        this.source.setIncrementalMode(true);
        this.testEmptyBlank();
    }

    @Test
    public void testSingleRecord() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n");
        Record r = (Record)it.next();
        Assert.assertEquals((String)"http://a", (String)r.getValue("ID"));
        Assert.assertEquals((String)"foo", (String)r.getValue("PROP"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSingleRecordInc() {
        this.source.setIncrementalMode(true);
        this.testSingleRecord();
    }

    @Test
    public void testSingleRecord2() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n<http://a> <http://c> \"foo\" .\n");
        Record r = (Record)it.next();
        Assert.assertEquals((String)"http://a", (String)r.getValue("ID"));
        Assert.assertEquals((String)"foo", (String)r.getValue("PROP"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSingleRecord2Inc() {
        this.source.setIncrementalMode(true);
        this.testSingleRecord2();
    }

    @Test
    public void testSingleRecord2Spaces() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        RecordIterator it = this.read("\n<http://a> <http://b> \"foo\" .\n\n<http://a> <http://c> \"foo\" .\n\n");
        Record r = (Record)it.next();
        Assert.assertEquals((String)"http://a", (String)r.getValue("ID"));
        Assert.assertEquals((String)"foo", (String)r.getValue("PROP"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSingleRecord2SpacesInc() {
        this.source.setIncrementalMode(true);
        this.testSingleRecord2Spaces();
    }

    @Test
    public void testTwoRecords() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n<http://a> <http://c> \"foo\" .\n<http://a> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> \"http://d\" .\n<http://e> <http://b> \"bar\" .\n<http://e> <http://c> \"foo\" .\n<http://e> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> \"http://f\" .\n");
        Record r = (Record)it.next();
        this.checkAorE(r);
        Assert.assertTrue((String)"second record not found", (boolean)it.hasNext());
        r = (Record)it.next();
        this.checkAorE(r);
    }

    private void checkAorE(Record r) {
        if (r.getValue("ID").equals("http://a")) {
            Assert.assertEquals((String)"foo", (String)r.getValue("PROP"));
        } else {
            Assert.assertEquals((String)"http://e", (String)r.getValue("ID"));
            Assert.assertEquals((String)"bar", (String)r.getValue("PROP"));
        }
    }

    @Test
    public void testTwoRecordsInc() {
        this.source.setIncrementalMode(true);
        this.testTwoRecords();
    }

    @Test
    public void testTypeFiltering() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        this.source.setAcceptTypes("http://d");
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n<http://a> <http://c> \"foo\" .\n<http://a> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> \"http://d\" .\n<http://e> <http://b> \"bar\" .\n<http://e> <http://c> \"foo\" .\n<http://e> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> \"http://f\" .\n");
        Record r = (Record)it.next();
        Assert.assertEquals((String)"http://a", (String)r.getValue("ID"));
        Assert.assertEquals((String)"foo", (String)r.getValue("PROP"));
        Assert.assertFalse((String)"e record not filtered out", (boolean)it.hasNext());
    }

    @Test
    public void testTypeFilteringInc() {
        this.source.setIncrementalMode(true);
        this.testTypeFiltering();
    }

    @Test
    public void testSingleRecordDoubleProp() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        this.source.addColumn(new Column("http://b", "PROP2", null, null));
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n");
        Record r = (Record)it.next();
        Assert.assertEquals((String)"http://a", (String)r.getValue("ID"));
        Assert.assertEquals((String)"foo", (String)r.getValue("PROP"));
        Assert.assertEquals((String)"foo", (String)r.getValue("PROP2"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSingleRecordDoublePropInc() {
        this.source.setIncrementalMode(true);
        this.testSingleRecordDoubleProp();
    }

    @Test
    public void testRealData() {
        String data = "<http://data.deichman.no/person/ahlgren_ernst_1850-1888> <http://data.deichman.no/catalogueName> \"Ahlgren, Ernst\" .\n<http://data.deichman.no/person/ahlgren_ernst_1850-1888> <http://data.deichman.no/lifespan> \"1850-1888\" .\n<http://data.deichman.no/person/ahlgren_ernst_1850-1888> <http://www.foafrealm.org/xfoaf/0.1/nationality> <http://data.deichman.no/nationality/sv> .\n<http://data.deichman.no/person/ahlgren_ernst_1850-1888> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://xmlns.com/foaf/0.1/Person> .\n<http://data.deichman.no/person/ahlgren_ernst_1850-1888> <http://xmlns.com/foaf/0.1/name> \"Ahlgren, Ernst\" .\n<http://data.deichman.no/person/ahlgren_ernst_1850-1888> <http://xmlns.com/foaf/0.1/title> \"psevd. for Victoria Benedictsson\" .\n";
        RegexpCleaner birthcleaner = new RegexpCleaner();
        birthcleaner.setRegexp("^(\\d\\d\\d\\d)-");
        RegexpCleaner deathcleaner = new RegexpCleaner();
        deathcleaner.setRegexp("-(\\d\\d\\d\\d)$");
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://xmlns.com/foaf/0.1/name", "NAME", null, (Cleaner)new FamilyCommaGivenCleaner()));
        this.source.addColumn(new Column("http://data.deichman.no/lifespan", "YEAROFBIRTH", null, (Cleaner)birthcleaner));
        this.source.addColumn(new Column("http://data.deichman.no/lifespan", "YEAROFDEATH", null, (Cleaner)deathcleaner));
        RecordIterator it = this.read(data);
        Record r = (Record)it.next();
        Assert.assertEquals((String)"http://data.deichman.no/person/ahlgren_ernst_1850-1888", (String)r.getValue("ID"));
        Assert.assertEquals((String)"ernst ahlgren", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"1850", (String)r.getValue("YEAROFBIRTH"));
        Assert.assertEquals((String)"1888", (String)r.getValue("YEAROFDEATH"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testCleanedNullIsDiscarded() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, (Cleaner)new NullCleaner()));
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n");
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testCleanedEmptyIsDiscarded() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, (Cleaner)new EmptyCleaner()));
        RecordIterator it = this.read("<http://a> <http://b> \"foo\" .\n");
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testEmptyRecord() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://b", "PROP", null, null));
        RecordIterator it = this.read("<http://a> <http://c> \"foo\" .\n");
        Assert.assertFalse((String)"failed to filter out empty records", (boolean)it.hasNext());
    }

    private RecordIterator read(String csvdata) {
        this.source.setReader((Reader)new StringReader(csvdata));
        return this.source.getRecords();
    }

    static class EmptyCleaner
    implements Cleaner {
        EmptyCleaner() {
        }

        public String clean(String value) {
            return "";
        }
    }

    static class NullCleaner
    implements Cleaner {
        NullCleaner() {
        }

        public String clean(String value) {
            return null;
        }
    }
}

