INCLUDE(FindPackageHandleStandardArgs)

IF (NOT DEFINED GPUNUFFT_ROOT_DIR)
  MESSAGE(FATAL_ERROR "GPUNUFFT_ROOT_DIR not defined!")
ELSE()
  MESSAGE("Searching for GPUNUFFT in ${GPUNUFFT_ROOT_DIR}")

  SET(GPUNUFFT_IncludeSearchPaths ${GPUNUFFT_ROOT_DIR}/CUDA/inc ${GPUNUFFT_ROOT_DIR}/inc) #/usr/local/include
  SET(GPUNUFFT_LibrarySearchPaths ${GPUNUFFT_ROOT_DIR}/CUDA/bin ${GPUNUFFT_ROOT_DIR}/bin) #/usr/local/lib

  FIND_PATH(GPUNUFFT_INCLUDE_DIRS NAMES gpuNUFFT_operator_factory.hpp PATHS ${GPUNUFFT_IncludeSearchPaths})

  FIND_LIBRARY(GPUNUFFT_LIBRARIES NAMES gpuNUFFT gpuNUFFT_ATM_f gpuNUFFT_f  PATHS ${GPUNUFFT_LibrarySearchPaths})

  #Handle the REQUIRED argument and set the < UPPERCASED_NAME > _FOUND variable
  FIND_PACKAGE_HANDLE_STANDARD_ARGS(GPUNUFFT "Could NOT find GPUNUFFT." GPUNUFFT_LIBRARIES GPUNUFFT_INCLUDE_DIRS)
  IF(GPUNUFFT_FOUND)
    FIND_PACKAGE_MESSAGE(
        GPUNUFFT      
        "Found GPUNUFFT ${GPUNUFFT_LIBRARIES}"
        "[${GPUNUFFT_LIBRARIES}][${GPUNUFFT_INCLUDE_DIRS}]")
    ENDIF(GPUNUFFT_FOUND)
  MARK_AS_ADVANCED(GPUNUFFT_INCLUDE_DIRS GPUNUFFT_LIBRARIES)
ENDIF()
