"""init

Revision ID: 0000
Revises: 
Create Date: 2022-04-05 17:52:16.030969

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0000"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "nb_auth_user",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("username", sa.String(), nullable=False),
        sa.Column("password", sa.BINARY(), nullable=True),
        sa.Column("is_superuser", sa.Boolean(), nullable=False),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("scopes", sa.String(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_nb_auth_user_username"), "nb_auth_user", ["username"], unique=True
    )
    op.create_table(
        "nb_project",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("projectid", sa.String(length=16), nullable=False),
        sa.Column("name", sa.String(length=128), nullable=False),
        sa.Column("private_key", sa.BINARY(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("repository", sa.String(length=2048), nullable=True),
        sa.Column("owner_id", sa.BigInteger(), nullable=False),
        sa.Column("agent_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["agent_id"], ["nb_auth_user.id"], ondelete="SET NULL"),
        sa.ForeignKeyConstraint(["owner_id"], ["nb_auth_user.id"], ondelete="SET NULL"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_index(
        op.f("ix_nb_project_projectid"), "nb_project", ["projectid"], unique=True
    )
    op.create_table(
        "nb_history",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("wfid", sa.String(length=24), nullable=True),
        sa.Column("execid", sa.String(length=24), nullable=True),
        sa.Column("nb_name", sa.String(), nullable=False),
        sa.Column("result", sa.JSON(), nullable=False),
        sa.Column("elapsed_secs", sa.Float(), nullable=False),
        sa.Column("status", sa.Integer(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"], ["nb_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_nb_history_created_at"), "nb_history", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_nb_history_status"), "nb_history", ["status"], unique=False
    )
    op.create_table(
        "nb_projects_users",
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.Column("user_id", sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["nb_project.projectid"],
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["nb_auth_user.id"],
        ),
    )
    op.create_table(
        "nb_runtime",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("docker_name", sa.String(), nullable=False),
        sa.Column("version", sa.String(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"], ["nb_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_nb_runtime_created_at"), "nb_runtime", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_nb_runtime_docker_name"), "nb_runtime", ["docker_name"], unique=True
    )
    op.create_table(
        "nb_workflow",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("wfid", sa.String(length=24), nullable=True),
        sa.Column("alias", sa.String(length=33), nullable=False),
        sa.Column("nbtask", sa.JSON(), nullable=False),
        sa.Column("schedule", sa.JSON(), nullable=False),
        sa.Column("enabled", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=True
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"], ["nb_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("alias", "project_id", name="_nb_workflow__project_alias"),
    )
    op.create_index(
        op.f("ix_nb_workflow_alias"), "nb_workflow", ["alias"], unique=False
    )
    op.create_index(op.f("ix_nb_workflow_wfid"), "nb_workflow", ["wfid"], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_nb_workflow_wfid"), table_name="nb_workflow")
    op.drop_index(op.f("ix_nb_workflow_alias"), table_name="nb_workflow")
    op.drop_table("nb_workflow")
    op.drop_index(op.f("ix_nb_runtime_docker_name"), table_name="nb_runtime")
    op.drop_index(op.f("ix_nb_runtime_created_at"), table_name="nb_runtime")
    op.drop_table("nb_runtime")
    op.drop_table("nb_projects_users")
    op.drop_index(op.f("ix_nb_history_status"), table_name="nb_history")
    op.drop_index(op.f("ix_nb_history_created_at"), table_name="nb_history")
    op.drop_table("nb_history")
    op.drop_index(op.f("ix_nb_project_projectid"), table_name="nb_project")
    op.drop_table("nb_project")
    op.drop_index(op.f("ix_nb_auth_user_username"), table_name="nb_auth_user")
    op.drop_table("nb_auth_user")
    # ### end Alembic commands ###
