从 pygame.surface 导入 *
从 typing 导入 TypeVar
从 游戏派.类库.区块 导入 区块类


类 表层类():
    ''' 表层对象用于表示任何一个图像，表层对象具有固定的分辨率和像素格式。\n
    表层对象通过 8 位索引调色板的 24 位色彩。\n
    实例化一: 表层类((宽,高), 标识=0, 色深=0, 蒙层=None) -> 表层类\n
    实例化二: 表层类((宽,高), 标识=0, 表层) -> 表层类
    '''
    套路 __初始化__(自身,*参数,**表层字典):
        如果 isinstance(参数[0],Surface):
            自身.surface=参数[0]
        否则:
            自身.surface = Surface(*参数,**表层字典)

    套路 贴图(自身,表层, 左顶点, 区块=空, 标识=0)->'区块类':
        '''将一个表层贴到当前表层上,
        <表层>可以为图像表层或一个普通表层
        <左顶点>在目标表层某个点开始贴图
        <区块>在目标表层一个区块里贴图
        '''
        返回 区块类(自身.surface.blit(表层.surface, 左顶点, 区块, 标识))

    套路 转换格式(自身,*参数,**表层字典)->'表层类':
        '''修改图像表层的像素格式。\n
        参数选项: 表层类实例\n
        参数选项: 色深 flags=0\n
        参数选项: 蒙层 flags=0\n
        返回: 表层新实例
        '''
        如果 len(参数)==1 且 isinstance(参数[0],表层类):
            返回 表层类(自身.surface.convert(参数[0].surface))
        返回 表层类(自身.surface.convert(*参数,**表层字典))

    套路 转换透明格式(自身,*参数,**表层字典)->'表层类':
        '''修改图像表层的像素格式，包含 透明 通道\n
        参数选项: 表层类实例\n
        参数选项: 无\n
        返回: 表层新实例
        '''
        如果 len(参数)==1 且 isinstance(参数[0],表层类):
            返回 表层类(自身.surface.convert_alpha(参数[0].surface))
        返回 表层类(自身.surface.convert_alpha(*参数,**表层字典))

    套路 复制(自身)->'表层类':
        '''创建一个 Surface 对象的拷贝\n
        参数: 无\n
        返回: 表层新实例,拥有相同的像素格式、调色板和透明度设置。
        '''
        返回 表层类(自身.surface.copy())

    套路 填充(自身,颜色, 区块=空, 特殊标识=0)->'区块类':
        '''使用纯色填充 表层 对象\n
        参数: <颜色>为(R,G,B,A)元组.<区块>为限定填充的一块区域,空则填充全表层.<特殊标识>指定混合的模式\n
        返回: 填充的区块
        '''
        返回 区块类(自身.surface.fill(颜色, 区块, 特殊标识))

    套路 滚动(自身,偏移x=0, 偏移y=0):
        '''移动 表层 对象\n
        参数: <偏移x>为水平方向偏移量.<偏移y>为垂直方向偏移量.\n
        返回: 空
        '''
        自身.surface.scroll(偏移x, 偏移y)

    套路 设置颜色键(自身,*参数):
        '''设置 colorkeys\n
        参数选项: <颜色>, <标识=0>\n
        参数选项: 空,取消 colorkeys 的设置\n
        返回: 空
        '''
        如果 len(参数)==0:
            自身.surface.set_colorkey()
        或如 len(参数)==1:
            自身.surface.set_colorkey(参数[0],0)
        或如 len(参数)==2:
            自身.surface.set_colorkey(参数[0],参数[1])

    套路 获取颜色键(自身):
        '''获取 colorkeys\n
        参数选项: 空\n
        返回: 表层对象当前 colorkeys 的颜色值，如果没有设置 colorkeys，则返回 空
        '''
        返回 自身.surface.get_colorkey()

    套路 设置透明色(自身,*参数):
        '''设置整个表层的透明度\n
        参数选项: <颜色值>取值0~255,0 表示完全透明，255 表示完全不透明. <标识=0>\n
        参数选项: 空,取消透明设置\n
        返回: 空
        '''
        如果 len(参数)==0:
            自身.surface.set_alpha()
        或如 len(参数)==1:
            自身.surface.set_alpha(参数[0],0)
        或如 len(参数)==2:
            自身.surface.set_alpha(参数[0],参数[1])

    套路 获取透明值(自身):
        '''获取整个表层的透明度\n
        参数: 空\n
        返回: 表层对象当前 表层 的透明值，如果没有设置 透明值，则返回 空
        '''
        返回 自身.surface.get_alpha()

    套路 加锁(自身):
        '''锁定 表层 对象的内存使其可以进行像素访问\n
        参数: 空\n
        返回: 空
        '''
        自身.surface.lock()

    套路 解锁(自身):
        '''解锁 表层 对象的内存使其可以进行像素访问\n
        参数: 空\n
        返回: 空
        '''
        自身.surface.unlock()

    套路 检测加锁(自身):
        '''检测该 表层 对象是否需要被锁定\n
        参数: 空\n
        返回: 真 或 假
        '''
        返回 自身.surface.mustlock()

    套路 获取加锁状态(自身):
        '''获取该 表层 对象当前是否为锁定状态\n
        参数: 空\n
        返回: 真 或 假
        '''
        返回 自身.surface.get_locked()

    套路 获取已有锁定(自身):
        '''返回该 表层 对象当前存在的锁定\n
        参数: 空\n
        返回: 存在的锁定元组
        '''
        返回 自身.surface.get_locks()

    套路 设置像素颜色(自身,像素点,颜色):
        '''设置一个像素的颜色值\n
        参数: <像素点>(x,y)元组表示的点.<颜色>(r,g,b,a)元组表示的颜色
        返回: 空
        '''
        自身.surface.set_at(像素点,颜色)

    套路 获取像素颜色(自身,像素点):
        '''获取一个像素的颜色值\n
        参数: <像素点>(x,y)元组表示的点.<颜色>(r,g,b,a)元组表示的颜色
        返回: (r,g,b,a)元组表示的颜色
        '''
        返回 自身.surface.get_at(像素点)

    套路 获取像素索引(自身,像素点):
        '''获取一个像素映射的颜色索引号\n
        参数: <像素点>(x,y)元组表示的点
        返回: 索引号,整数型
        '''
        返回 自身.surface.get_at_mapped(像素点)

    套路 设置调色板(自身,颜色列表):
        '''设置 表层 对象 8 位索引的调色板\n
        参数: 颜色列表
        返回: 空
        '''
        自身.surface.set_palette(颜色列表)

    套路 获取调色板(自身):
        '''获取 表层 对象 8 位索引的调色板\n
        参数: 空
        返回: 一个最多包含 表层 对象映射的 256 种颜色的列表
        '''
        返回 自身.surface.get_palette()

    套路 设置调色板索引色(自身,索引,颜色):
        '''设置给定索引号在调色板中的颜色\n
        参数: <索引>,取值范围是 0 ~ 255整数.<颜色>,RGBA颜色元组.\n
        返回: 空
        '''
        自身.surface.set_palette_at(索引,颜色)

    套路 获取调色板索引色(自身,索引):
        '''获取给定索引号在调色板中的颜色值\n
        参数: <索引>,取值范围是 0 ~ 255整数\n
        返回: 索引在调色板中的RGBA颜色
        '''
        返回 自身.surface.get_palette_at(索引)

    套路 RGBA转映射值(自身,颜色):
        '''将一个 RGBA 颜色转换为映射的颜色值\n
        参数:<颜色>(r,g,b,a)元组表示的颜色\n
        返回: 映射的颜色值,整数型
        '''
        返回 自身.surface.map_rgb(颜色)

    套路 映射值转RGBA(自身,映射值):
        '''将一个映射的颜色值转换为 RGBA 颜色\n
        参数: 映射的颜色值\n
        返回: (r,g,b,a)元组表示的颜色
        '''
        返回 自身.surface.unmap_rgb(映射值)

    套路 设置剪切区(自身,*参数):
        '''设置该 表层 对象的当前剪切区域\n
        参数选项: <区块>,一个限定矩形，只有该矩形内的像素才可以被修改\n
        参数选项: 空,表示剪切区域覆盖整个 表层 对象\n
        返回: 空
        '''
        如果 len(参数)==0:
            自身.surface.set_clip()
        如果 len(参数)==1:
            自身.surface.set_clip(参数[0])

    套路 获取剪切区(自身)->'区块类':
        '''获取该 表层 对象的当前剪切区域\n
        参数: 空
        返回: 该 表层 对象的当前剪切区,为区块类实例
        '''
        返回 区块类(自身.surface.get_clip())

    套路 创建子表层(自身,区块)->'表层类':
        '''根据父表层创建一个新的子表层对象\n
        参数: <区块>,区块类实例\n
        返回: 一个子表层对象，它将与父对象共享所有的像素。\n
            修改子表层或父表层任一的像素均会影响到彼此，\n
            表层对象的信息像剪切区域，color keys 都是相同的。
        '''
        返回 表层类(自身.surface.subsurface(区块.rect))

    套路 获取父表层(自身)->'表层类':
        '''获取子表层对象的父表层\n
        参数: 空\n
        返回: 子表层对象的父表层，如果不存在父表层，则返回 None
        '''
        返回 表层类(自身.surface.get_parent())

    套路 获取顶层表层(自身)->'表层类':
        '''获取子表层对象的顶层父表层\n
        参数: 空
        返回: 子表层的顶层父表层，如果不存在父表层，则返回该表层对象本身
        '''
        返回 表层类(自身.surface.get_abs_parent())

    套路 获取偏移(自身)->元组型:
        '''获取子表层对象在父对象中的偏移位置\n
        参数: 空\n
        返回: 获取子表层对象在父对象中的偏移位置元组(x,y)。\n
            如果该子表层对象不是子对象，则返回 (0, 0)
        '''
        返回 自身.surface.get_offset()

    套路 获取顶层偏移(自身)->元组型:
        '''获取子表层对象在顶层父对象中的偏移位置\n
        参数: 空\n
        返回: 获取子表层对象在顶层父对象中的偏移位置元组(x,y)。\n
            如果该子表层对象不是子对象，则返回 (0, 0)
        '''
        返回 自身.surface.get_abs_offset()

    套路 获取尺寸(自身)->元组型:
        '''获取表层对象的尺寸\n
        参数: 空\n
        返回: 表层对象的(宽度,高度)元组，以像素为单位
        '''
        返回 自身.surface.get_size()

    套路 获取宽度(自身):
        '''获取表层对象的宽度\n
        参数: 空\n
        返回: 表层对象的宽度整数，以像素为单位
        '''
        返回 自身.surface.get_width()

    套路 获取高度(自身):
        '''获取表层对象的高度\n
        参数: 空\n
        返回: 表层对象的高度整数，以像素为单位
        '''
        返回 自身.surface.get_height()

    套路 获取区块(自身,**关键字)->'区块类':
        '''获取表层对象的矩形区域\n
        参数: <关键字>,返回的结果将受其影响\n
        返回: 一个区块对象表示该表层对象的矩形区域,以 (0, 0) 为起点
        '''
        返回 区块类(自身.surface.get_rect(**关键字))