从 pygame.sprite 导入 *

汉英属性 = {
    '图片':     'image',
    '区块':     'rect'
}

类 精灵汉化类:

    类 精灵类(Sprite):

        """可以游戏对象的简单基类

        游戏派.精灵.精灵类(*精灵组): 返回 精灵实例


        继承的类可以重载 更新() 套路数,并且设置图片和区块属性.初始化接受任意多个的精灵组实例,
        此精灵实例将成为其成员

        子类精灵初始时,应该调用基类的初始化套路数
        """

        套路 __初始化__(自身, *精灵组列表):
            Sprite.__初始化__(自身,*精灵组列表)

        套路 添加(自身, *精灵组列表):
            """添加当前精灵到任意个精灵组
            返回 空
            """
            Sprite.add(自身,*精灵组列表)

        套路 移除(自身, *精灵组列表):
            """将此精灵从精灵组列表中移除

            返回 空

            任意个精灵组类实例可作为参数

            """
            Sprite.remove(自身,*精灵组列表)

        套路 更新(自身, *参数):
            """控制精灵行为的套路数

            此套路数可以被精灵组的 更新() 套路数调用,子类可以重载此套路数

            """
            pass

        套路 自毁(自身):
            """将此精灵从所有精灵组中移除

            返回 空
            """
            Sprite.kill(自身)


        套路 精灵组列表型(自身):
            """返回包含些精灵的所有精灵组
            """
            返回 Sprite.groups(自身)

        套路 检测存活(自身):
            """当这个精灵属于任意一个精灵组则返回真,否则返回假
            """
            返回 Sprite.alive(自身)

        套路 __setattr__(自身, 键, 值):
            Sprite.__setattr__(自身,键, 值)
            如果 键=='图片':
                自身.image = 值.surface
            如果 键=='区块':
                自身.rect = 值.rect

    类 精灵组类(AbstractGroup):

        """包含一个或多个精灵的容器类
        游戏派.精灵.精灵组类(*精灵列表): 返回 精灵组实例
        """
        套路 __初始化__(自身, *精灵列表):
            AbstractGroup.__初始化__(自身)
            自身.添加(*精灵列表)
        
        套路 精灵列表型(自身):
            '''获取精灵组所包含的所有精灵\n
            参数:   无\n
            返回: 这个精灵组所包含的精灵列表
            '''
            返回 AbstractGroup.sprites(自身)
        
        套路 绘制(自身,表层):
            '''将精灵图像绘制到表层上\n
            参数: <表层>,用于绘制精灵的表层实例\n
            返回: 空
            '''
            AbstractGroup.draw(自身,表层.surface)

        套路 复制(自身)->'精灵组类':
            '''对当前精灵组进行复制,包含相同的精灵组\n
            参数: 空\n
            返回: 精灵组实例
            '''
            返回 AbstractGroup.copy(自身)

        套路 添加(自身,*精灵列表):
            '''添加一个或多个精灵进这个精灵组\n
            参数: 一个或多个精灵\n
            返回: 空
            '''
            AbstractGroup.add(自身,*精灵列表)

        套路 移除(自身,*精灵列表):
            '''将一个或多个精灵移除出这个精灵组\n
            参数: 一个或多个精灵\n
            返回: 空
            '''
            AbstractGroup.remove(自身,*精灵列表)

        套路 检测包含(自身,*精灵列表):
            '''检测一个或多个精灵是否包含在这个精灵组里\n
            参数: 一个或多个精灵\n
            返回: 当全部包含时返回真,否则返回假
            '''
            返回 AbstractGroup.has(自身,*精灵列表)

        套路 更新(自身,*参数):
            '''调用所包含所有精灵的 更新() 套路数\n
            参数: 万能参数,作为所有精灵  更新() 套路数的参数\n
            返回: 空
            '''
            for s in 自身.sprites():
                s.更新(*参数)

        套路 清屏(自身,表层,背景色):
            '''以背景色覆盖此精灵组所绘制的精灵\n
            参数: <表层>,准备以背景色填充的表层.<背景色>颜色元组\n
            返回: 空
            '''
            AbstractGroup.clear(自身,表层,背景色)

        套路 清空(自身):
            '''将此精灵组里的精灵全部清空\n
            参数: 空\n
            返回: 空
            '''
            AbstractGroup.empty(自身)
            
    套路 检测精灵碰撞(自身,精灵, 精灵组, 杀死, 碰撞回调 = 空):
        '''检测一个精灵是否与一个精灵组里一个或多个精灵扫生碰撞\n
        参数: <精灵>,<精灵组>,<杀死>,如果为真,精灵组里发生碰撞的精灵从精灵组中移除\n
            <碰撞回调>,两个精灵发生碰撞后,调用此回调套路数.此两精灵作为参数传递\n
        返回: 如果发生碰撞则返回精灵组里发生碰撞的精灵列表
        '''
        返回 spritecollide(精灵, 精灵组, 杀死, 碰撞回调)

    套路 检测矩形碰撞(自身,左精灵,右精灵):
        '''通过矩形碰撞检测,来测试两精灵是否发生碰撞\n
        参数: <左精灵>,<右精灵>两精灵实例\n
        返回: 如果发生碰撞,返回真,否则返回假
        '''
        返回 collide_rect(左精灵,右精灵)

    套路 检测圆形碰撞(自身,左精灵,右精灵):
        '''通过圆形碰撞检测,来测试两精灵是否发生碰撞\n
        参数: <左精灵>,<右精灵>两精灵实例\n
        返回: 如果发生碰撞,返回真,否则返回假
        '''
        返回 collide_circle(左精灵,右精灵)

    套路 检测矩形收缩碰撞(自身,比例):
        '''通过收缩矩形区块区域,来测试两精灵是否发生碰撞,更加准确\n
        参数: <比例>,收缩的比例\n
        返回: 可调用碰撞
        '''
        返回 collide_rect_ratio(比例)

    套路 检测圆形收缩碰撞(自身,比例):
        '''通过收缩圆形区块区域,来测试两精灵是否发生碰撞,更加准确\n
        参数: <比例>,收缩的比例\n
        返回: 可调用碰撞
        '''
        返回 collide_circle_ratio(比例)

    套路 检测蒙层碰撞(自身,左精灵,右精灵):
        '''通过两精灵的蒙层碰撞,来测试两精灵是否发生碰撞\n
        参数: <左精灵>,<右精灵>两精灵实例\n
        返回: 碰撞时首先接触的点元组,未碰撞返回空
        '''
        返回 collide_mask(左精灵,右精灵)

    套路 检测精灵组碰撞(自身,精灵组1, 精灵组2, 杀死1,杀死2, 碰撞回调 = 空):
        '''检测一个精灵组是否与一个精灵组里一个或多个精灵扫生碰撞\n
        参数: <精灵>,<精灵组>,<杀死>,如果为真,精灵组里发生碰撞的精灵从精灵组中移除\n
            <碰撞回调>,两个精灵发生碰撞后,调用此回调套路数.此两精灵作为参数传递\n
        返回: 如果发生碰撞则返回精灵组里发生碰撞的精灵字典,无碰撞则返回空字典
        '''
        返回 groupcollide(精灵组1, 精灵组2, 杀死1,杀死2, 碰撞回调)

    套路 检测精灵与组碰撞(自身,精灵, 精灵组,杀死,碰撞回调 = 空):
        '''检测一个精灵是否与一个精灵组里一个或多个精灵扫生碰撞\n
        参数: <精灵>,精灵类实例\n
            <精灵组>,精灵组实例\n
            <杀死>,如果为真,精灵组里发生碰撞的精灵从精灵组中移除\n
            <碰撞回调>,两个精灵发生碰撞后,调用此回调套路数.此两精灵作为参数传递\n
        返回: 如果发生碰撞则返回精灵组里发生碰撞的单一精灵,否则返回空
        '''
        返回 spritecollide(精灵, 精灵组, 杀死, 碰撞回调)