从 pygame.mixer 导入 *

类 音乐汉化类:

    套路 读取(自身,参数):
        '''载入一个音乐文件用于播放\n
        参数: <文件名>或<文件对象>\n
        返回: 空
        '''       
        music.load(参数)

    套路 播放(自身,循环=0,开始位置=0.0):
        '''开始播放音乐流\n
        参数: <循环>参数控制重复播放的次数, -1，则表示无限重复播放\n
              <开始位置>参数控制音乐从哪里开始播放,单位为秒
        返回: 空
        '''       
        music.play(循环,开始位置)

    套路 重新播放(自身):
        '''从文件开头开始重新播放音乐。\n
        参数: 空\n
        返回: 空
        '''       
        music.rewind()

    套路 停止(自身):
        '''结束音乐播放\n
        参数: 空\n
        返回: 空
        '''       
        music.stop()

    套路 暂停(自身):
        '''暂停音乐流的播放\n
        参数: 空\n
        返回: 空
        '''       
        music.pause()

    套路 继续(自身):
        '''恢复音乐流的播放\n
        参数: 空\n
        返回: 空
        '''       
        music.unpause()

    套路 淡出停止(自身,时间):
        '''淡出的效果结束音乐播放,该套路数在调用后会一直处于阻塞状态，直到音乐已经淡出\n
        参数: <时间>毫秒\n
        返回: 空
        '''       
        music.fadeout(时间)

    套路 设置音量(自身,音量):
        '''设置播放频道的音量,当新的音乐文件被载入，音量会被重置\n
        参数选项:   <音量>播放声音的音量（响度）,介于0.0和1.0之间\n
        返回:   无
        '''
        music.set_volume(音量)

    套路 获取音量(自身):
        '''获取播放音乐流的音量\n
        返回:   当前播放音乐流的音量
        '''
        返回 music.get_volume()

    套路 检查播放状态(自身):
        '''检查是否正在播放音乐\n
        返回: 有音乐流正在播放，此方法返回真。否则返回假
        '''
        返回 music.get_busy()

    套路 设置播放位置(自身,位置):
        '''设置播放的位置\n
        参数: <位置>,是一个浮点数,以秒为单位
        返回: 空
        '''
        music.set_pos(位置)

    套路 获取播放位置(自身):
        '''获取播放的位置\n
        参数: 空
        返回: 音乐已经播放了多久,毫秒为单位
        '''
        返回 music.get_pos()

    套路 切换(自身,文件名):
        '''将一个音乐文件放入队列中，并排在当前播放的音乐之后\n
        参数: <文件名>,准备切换放入的音乐 
        返回: 空
        '''
        music.queue()

    套路 设置结束事件(自身,*参数):
        '''当音乐流播放结束时发出一个事件\n
        参数选项: 空\n
        参数选项: <类型>发送到队列的事件id\n
        返回: 空
        '''
        music.set_endevent(参数[0]) 如果 len(参数)==1 否则 自身.channel.set_endevent()

    套路 获取结束事件(自身):
        '''获取音乐流播放结束时发送的事件类型\n
        参数: 空\n
        返回: 音乐流播放结束时发送的事件类型。
        '''
        返回 music.get_endevent()


类 混音器汉化类:

    套路 __初始化__(自身):
        自身.音乐 = 音乐汉化类()

    '''用来控制声音播放\n
        频道类(id)\n
        频道类(频道实例)\n
    '''
    类 频道类:
        套路 __初始化__(自身,*参数):
            如果 len(参数)==1:
                如果 isinstance(参数[0],int):
                    自身.channel=Channel(参数[0])
                否则:
                    自身.channel=参数[0]

        套路 播放(自身,声音,循环=0,最长时间=0,淡入时间=0):
            '''在特定频道上播放声音\n
            参数:   <声音>声音类实例\n                       
                    <循环>重复的次数\n
                    <最长时间>在给定的毫秒数后停止播放\n
                    <淡入时间>使声音以0音量开始播放，并在给定时间内逐渐升至全音量
            返回: 所选频道对象
            '''
            返回 自身.channel.play(声音,循环,最长时间,淡入时间)

        套路 停止(自身):
            '''停止在频道上播放声音\n
            参数:   无\n
            返回:   无
            '''
            返回 自身.channel.stop()

        套路 暂停(自身):
            '''暂时停止播放频道\n
            参数:   无\n
            返回:   无
            '''
            返回 自身.channel.pause()

        套路 继续(自身):
            '''恢复暂停的播放频道\n
            参数:   无\n
            返回:   无
            '''
            返回 自身.channel.unpause()

        套路 淡出停止(自身,时间):
            '''在给定时间参数上淡出声音后，以毫秒为单位停止播放频道\n
            参数:   <时间>单位毫秒\n
            返回:   无
            '''
            返回 自身.channel.fadeout()

        套路 设置音量(自身,*参数):
            '''设置播放频道的音量\n
            参数选项:   <音量>播放声音的音量（响度）,介于0.0和1.0之间\n
            参数选项:   <左音量>是左扬声器的音量，<右音量>是右扬声器的音量\n
            返回:   无
            '''
            返回 自身.channel.set_volume(*参数)

        套路 获取音量(自身):
            '''获取播放频道的音量\n
            返回:   当前播放声音的频道音量
            '''
            返回 自身.channel.get_volume()

        套路 获取活动状态(自身):
            '''检查频道是否处于活动状态\n
            返回: 频道正在主动混合声音，则返回真。如果频道空闲，则返回假
            '''
            返回 自身.channel.get_busy()

        套路 获取声音(自身):
            '''得到当前播放的声音\n
            返回: 当前在此频道上播放的实际声音对象。如果频道空闲，则返回空
            '''
            返回 混音器汉化类.声音类(自身.channel.get_sound())

        套路 切换(自身,声音):
            '''当声音在频道上排队时，它将在当前声音结束后立即开始播放。\n
            参数: <声音>声音类实例\n
            返回: 空
            '''
            自身.channel.queue(声音.sound)

        套路 获取排队声音(自身):
            '''返回排队的任何声音\n
            参数: 空\n
            返回: 如果声音已在此频道上排队，则会返回该声音。\n
                一旦排队的声音开始播放，它将不再在队列中
            '''
            如果 isinstance(自身.channel.get_queue(),Sound):
                返回 混音器汉化类.声音类(自身.channel.get_queue())

        套路 设置结束事件(自身,*参数):
            '''播放停止时让频道发送事件\n
            参数选项: 空\n
            参数选项: <类型>发送到队列的事件id\n
            返回: 空
            '''
            自身.channel.set_endevent(参数[0]) 如果 len(参数)==1 否则 自身.channel.set_endevent()

        套路 获取结束事件(自身):
            '''获取播放停止时频道发送的事件\n
            参数: 空\n
            返回: 每次频道完成声音播放时要发送的事件类型。
            '''
            返回 自身.channel.get_endevent()

    '''实际的声音样本数据
        声音类(文件名)
        声音类(文件=文件名)
        声音类(缓存)
        声音类(缓存=缓存)
        声音类(对象)
        声音类(文件=对象)
        声音类(数组=对象)
    '''
    类 声音类:
        套路 __初始化__(自身,*参数,**关键字):
            如果 len(参数)==1:
                自身.sound = Sound(参数[0])
            或如 len(关键字)==1:
                如果 '文件' 在 关键字:
                    自身.sound = Sound(file=关键字['文件'])
                或如 '缓存' 在 关键字:
                    自身.sound = Sound(buffer=关键字['缓存'])
                或如 '数组' 在 关键字:
                    自身.sound = Sound(array=关键字['数组'])
        
        套路 播放(自身,循环=0,最长时间=0,淡入时间=0):
            '''开始播放声音\n
            参数:   <循环>重复的次数
                    <最长时间>在给定的毫秒数后停止播放
                    <淡入时间>使声音以0音量开始播放，并在给定时间内逐渐升至全音量
            返回: 所选频道对象
            '''
            return 混音器汉化类.频道类(自身.sound.play(循环,最长时间,淡入时间))
        
        套路 停止(自身):
            '''停止在任何活动频道上播放此声音\n
            参数: 空\n
            返回: 空\n
            '''
            自身.sound.stop()

        套路 淡出停止(自身,时间):
            '''在给定时间参数上淡出声音后，以毫秒为单位声音会在所有播放的频道上消失并停止\n
            参数:   <时间>单位毫秒\n
            返回:   无
            '''
            自身.sound.fadeout()

        套路 设置音量(自身,音量):
            '''设置此声音的播放音量\n
            参数:   <音量>播放声音的音量（响度）,介于0.0和1.0之间\n
            返回:   无
            '''
            自身.sound.set_volume(音量)

        套路 获取音量(自身):
            '''获取播放音量\n
            返回:   当前声音的播放音量
            '''
            返回 自身.sound.get_volume()

        套路 获取频道数(自身):
            '''获取此声音正在播放的活动频道数\n
            返回:   此声音正在播放的活动频道数
            '''
            返回 自身.sound.get_num_channels()

        套路 获取声长(自身):
            '''获取此声音的长度\n
            返回:   时间长度,单位秒
            '''
            返回 自身.sound.get_length()

        套路 获取字节(自身):
            '''获取此声音的长度\n
            返回: 声音对象缓冲区的字节副本
            '''
            返回 自身.sound.get_raw()

    套路 初始化(自身,频率=22050,位数=-16,声道=2,采样=4096):
        '''初始化混音器模块\n
        参数:   <频率>\n
                <位数>每个音频样本使用的位数\n
                <声道>指定是使用单声道还是立体声。1表示单声道，2表示立体声。\n
                <采样>控制混音器中使用的内部采样数\n
        返回: 空
        '''       
        init(频率,位数,声道,采样)

    套路 预设初始化(自身,频率=22050,位数=-16,声道=2,采样=4096):
        '''预设混音器初始化参数,调用预设初始化可以更改调用真正的初始化使用的默认值。\n
        参数:   <频率>\n
                <位数>每个音频样本使用的位数\n
                <声道>指定是使用单声道还是立体声。1表示单声道，2表示立体声。\n
                <采样>控制混音器中使用的内部采样数\n
        返回: 空
        '''       
        pre_init(频率,位数,声道,采样)

    套路 退出(自身):
        '''退出混音器\n
        参数: 空\n
        返回: 空
        '''       
        quit(频率,位数,声道,采样)

    套路 检测初始化(自身):
        '''混音器是否初始化\n
        参数: 空\n
        返回: 如果混合器已初始化，则返回正在使用的播放参数元组。如果混音器尚未初始化，则返回空
        '''       
        返回 get_init()               

    套路 停止(自身):
        '''停止播放所有声道\n
        参数: 空\n
        返回: 空
        '''       
        stop()

    套路 暂停(自身):
        '''暂停播放所有声道\n
        参数: 空\n
        返回: 空
        '''       
        pause()

    套路 继续(自身):
        '''恢复播放声道\n
        参数: 空\n
        返回: 空
        '''       
        unpause()

    套路 淡出停止(自身,时间):
        '''设定时间上淡出所有活动通道上的音量，时间以毫秒为单位。声音静音后，播放将停止。\n
        参数: <时间>设定的时间,单位毫秒\n
        返回: 空
        '''       
        fadeout(时间)

    套路 设置频道数(自身,数量):
        '''设置播放频道的总数\n
        参数: <数量>调音台的可用频道数,默认值为8,如果该值减小，则截断的通道上播放的声音将停止\n
        返回: 空
        '''       
        set_num_channels(数量)

    套路 获取频道数(自身):
        '''获取播放频道的总数\n
        参数: 空\n
        返回: 当前活动的播放通道数
        '''       
        返回 get_num_channels(数量)

    套路 预定频道(自身,数量):
        '''预定任意数量的通道，这些通道不会被声音自动选择播放。这允许应用程序为重要声音保留特定数量的声道\n
        参数:  <数量>预定的频道数\n
        返回: 空
        '''       
        set_reserved(数量)

    套路 查找频道(自身,强制=假):
        '''找到一个未使用的频道\n
        参数:  <强制>为真时,如果没有空闲通道,会找到运行时间最长的声道并返回\n
        返回: 频道类实例 或 空
        '''       
        返回 find_channel(强制)

    套路 获取状态(自身):
        '''测试混音器是否正忙\n
        参数:  空\n
        返回: 混音器正忙，则返回真。如果混音器处于空闲状态，则返回假
        '''       
        返回 get_busy()