导入 pygame
从 游戏派.类库.表层 导入 表层类

类 显示汉化类():
    套路 __init__(自身):
        自身.表层=表层类((0,0))

    套路 初始化(自身):
        '''初始化显示对象\n
        游戏.初始化()也可以执行这个套路数
        '''
        pygame.display.init()

    套路 获取初始化(自身):
        '''得到显示的初始化状态\n
        如果已初始化返回True,否则返回False
        '''
        返回 pygame.display.get_init()

    套路 获取表层(自身)->'表层类':
        '''得到显示上的表层,返回表层
        '''
        自身.表层.surface = pygame.display.get_surface()
        返回 自身.表层

    套路 退出(自身):
        '''取消显示模块
        游戏.结束()也调用该套路数
        '''
        pygame.display.quit()

    套路 设置模式(自身, 尺寸=(0, 0), 标识=0, 色深=0, 显示模式=0)->'表层类':
        返回 表层类(pygame.display.set_mode(尺寸, 标识, 色深, 显示模式))

    套路 翻动(自身):
        '''更新整个待显示的表层对象到屏幕上
        '''
        pygame.display.flip()

    套路 更新(自身,区块=空):
        '''将区块或区块列表在显示上更新,如果为空,则更新所有区块
        '''
        如果 区块:
            如果 isinstance(区块,区块类):
                pygame.display.update(区块.rect)
            否则:
                _rectlist = 列表型(_l.rect 取 _l 于 区块)
                pygame.display.update(_rectlist)
        否则:
            pygame.display.update()

    套路 获取驱动(自身):
        '''得到屏幕的驱动标识
        '''
        返回 pygame.display.get_driver()

    套路 获取环境信息(自身):
        '''得到屏幕的驱动标识
        '''
        返回 pygame.display.Info()

    套路 获取系统信息(自身):
        '''得到操作系统的有关信息
        '''
        返回 pygame.display.get_wm_info()

    套路 获取全屏分辨率(自身, 色深=0, 标识=pygame.FULLSCREEN, 显示=0):
        '''获取全屏时可用的分辨率\n
        参数: <色深>,颜色深度\n
            <标识>,指定显示模式\n
            <显示>,显示的索引\n
        返回: 分辨率列表
        '''
        返回 pygame.display.list_modes(色深, 标识, 显示)

    套路 适配色深(自身, 尺寸, 标识=0, 色深=0):
        '''为显示模式选择最合适的颜色深度\n
        参数: <尺寸>,元组型\n
            <标识>,指定显示模式\n
            <色深>,用于有多个色深的情况\n
        返回: 显示需求的像素深度,如果不支持返回0
        '''
        返回 pygame.display.mode_ok(尺寸, 标识, 色深)

    套路 获取GL属性(自身,标识):
        '''获取当前显示模式 OpenGL 的属性值\n
        参数: <标识>\n
        返回: 标识对应的属性值
        '''
        返回 pygame.display.gl_get_attribute(标识)

    套路 设置GL属性(自身,标识,属性值):
        '''设置当前显示模式的 OpenGL 属性值\n
        参数: <标识>\n
            <属性值>\n
        返回: 空
        '''
        pygame.display.gl_set_attribute(标识,属性值)

    套路 获取激活状态(自身):
        '''获取当前显示界面的激活状态\n
        参数: 空\n
        返回: 表层对象被正常显示在屏幕上,返回真,隐藏或最小化，返回假
        '''
        返回 pygame.display.get_active()

    套路 最小化(自身):
        '''将当前表层最小化或隐藏\n
        参数: 空\n
        返回: 并不是所有的操作系统都支持最小化显示界面。\n
        如果该套路数调用成功，返回真,否则返回假
        '''
        返回 pygame.display.iconify()

    套路 最小化(自身):
        '''将当前表层最小化或隐藏\n
        参数: 空\n
        返回: 并不是所有的操作系统都支持最小化显示界面。\n
        如果该套路数调用成功，返回真,否则返回假
        '''
        返回 pygame.display.iconify()

    套路 切换全屏(自身):
        '''切换全屏模式和窗口模式\n
        参数: 空\n
        返回: 这个套路数只在 unix x11 显示驱动下工作\n
        如果该套路数调用成功，返回真,否则返回假
        '''
        返回 pygame.display.toggle_fullscreen()

    套路 设置伽马(自身,红,绿=空,蓝=空):
        '''修改硬件显示的 gama 坡道\n
        参数: <红>,红色伽马值\n
            <绿>,绿色伽马值\n
            <蓝>,蓝色伽马值\n
        返回: 不是所有的操作系统和硬件都支持伽马坡道\n
        如果该套路数调用成功，返回真,否则返回假
        '''
        返回 pygame.display.set_gamma(红,绿,蓝)

    套路 设置自定义伽马(自身,红,绿,蓝):
        '''使用自定义表设置硬件驱动显示的红色、绿色和蓝色伽马坡道\n
        参数: <红>,红色伽马值\n
            <绿>,绿色伽马值\n
            <蓝>,蓝色伽马值\n
        返回: 不是所有的操作系统和硬件都支持伽马坡道\n
        如果该套路数调用成功，返回真,否则返回假
        '''
        返回 pygame.display.set_gamma_ramp(红,绿,蓝)

    套路 设置图标(自身,图标):
        '''修改显示窗口的图标\n
        参数: <图标>,图标表层实例,大小是 32 * 32\n
        返回: 空\n
        '''
        pygame.display.set_icon(图标)

    套路 设置标题栏(自身,标题,图标标题=空):
        '''设置当前窗口的标题栏\n
        参数: <标题>,窗口标题栏文字\n
            <图标标题>,最小化窗口时切换的标题文字\n
        返回: 空\n
        '''
        如果  图标标题:
            pygame.display.set_caption(标题,图标标题)
        否则:
            pygame.display.set_caption(标题)

    套路 获取标题栏(自身):
        '''获取当前窗口的标题栏\n
        参数: 空\n
        返回: 返回当前窗口的标题栏和最小化标题栏字符串元组\n
        '''
        返回 pygame.display.get_caption()

    套路 设置调色板(自身,调色板=空):
        '''设置显示界面的8 位调色板\n
        参数: <调色板>,一组 RGB 三元组序列\n
        返回: 空\n
        '''
        pygame.display.set_palette(调色板)

