从 pygame.rect 导入 *

汉英属性 = {
    '顶':     'top',
    '左':     'left',
    '底':     'bottom',
    '右':     'right',
    '顶左':     'topleft',
    '顶右':     'topright',
    '底左':     'bottomleft',
    '底右':     'bottomright',
    '中顶':     'midtop',
    '中左':     'midleft',
    '中右':     'midright',
    '中心':     'center',
    '中心x':     'centerx',
    '中心y':     'centery',
    '尺寸':     'size',
    '宽度':     'width',
    '高度':     'height',
    'x':       'x',
    'y':       'y'
}

# 英汉属性 = {v: k 取 k, v 于 汉英属性.项()}

类 区块类:
   '''
   一个矩形区域
   '''

   套路 __初始化__(自身,*参数,**区块字典):
      自身.rect = Rect(*参数,**区块字典)

   套路 __setattr__(自身, 键, 值):
      如果 键=='rect':
         自身.__dict__['rect']=值
      否则:
         自身.rect.__setattr__(汉英属性[键],值)

   套路 __getattr__(自身, 键):
      返回 自身.rect.__getattribute__(汉英属性[键])

   套路 复制(自身):
      '''拷贝区块对象
      返回一个新的rect对象  
      '''
      返回 区块类(自身.rect.copy())

   套路 移动(自身,x,y):
      '''移动区块对象,返回一个新的区块对象
      x,y是偏移的值
      '''        
      返回 区块类(自身.rect.move(x,y))

   套路 移动_ip(自身,x,y):
      '''移动区块自己
      x,y是偏移的值
      '''        
      自身.rect.move_ip(x,y)    

   套路 缩放(自身,x,y):
      '''放大和缩小 Rect 对象的尺寸。
      返回一个新的 Rect 对象。x 和 y 参数指定新的对象放大或缩小多少像素。新的对象保持与原始 Rect 对象在同一个中心上。
      '''        
      返回 区块类(自身.rect.inflate(x,y))

   套路 缩放_ip(自身,x,y):
      '''原地放大和缩小 区块 对象的尺寸。
      不返回新的区块
      '''
      自身.rect.inflate_ip(x,y)
   
   套路 对齐(自身,区块):
      '''将一个 区块 对象移动到另一个 区块 对象的中心。
      返回新的区块
      '''        
      返回 区块类(自身.rect.clamp(区块.rect))

   套路 对齐_ip(自身,区块):
      '''将一个 区块 对象移动到另一个 区块 对象的中心。
      返回无
      '''        
      自身.rect.clamp_ip(区块.rect)

   套路 裁剪(自身,区块):
      '''获取两个 Rect 对象互相重叠的部分
      返回一个新的 Rect 对象，范围是原始 Rect 对象与 Rect 参数指定的对象互相重叠的部分。\n
      如果两个 Rect 对象没有任何重叠，则返回一个 (0, 0, 0, 0) 的 Rect 对象。
      '''        
      返回 区块类(自身.rect.clip(区块.rect))

   套路 联合(自身,区块):
      '''将两个 Rect 对象合并
      返回一个新的 Rect 对象，范围将包含原始 Rect 对象与 Rect 参数指定的对象。\n
      由于结果返回一个新的矩形，所以会产生一些多与的空间。
      '''        
      返回 区块类(自身.rect.union(区块.rect))

   套路 联合_ip(自身,区块):
      '''将两个 Rect 对象合并
      效果跟 联合复制() 方法一样，区别是这个直接作用于当前 区块 对象，而不是返回一个新的
      返回无
      '''        
      自身.rect.union_ip(区块.rect)

   套路 联合区块组(自身,区块列表):
      '''将两个 Rect 对象合并
      返回一个新的 Rect 对象，范围将包含原始 Rect 对象与 Rect 参数指定的对象。\n
      由于结果返回一个新的矩形，所以会产生一些多与的空间。
      '''
      返回 区块类(自身.rect.unionall(列表型(值.rect 取 值 于 区块列表)))

   套路 联合区块组_ip(自身,区块列表):
      '''将两个 Rect 对象合并
      效果跟 联合复制() 方法一样，区别是这个直接作用于当前 区块 对象，而不是返回一个新的
      返回无
      '''
      自身.rect.unionall_ip(列表型(值.rect 取 值 于 区块列表))

   套路 匹配(自身,区块):
      '''按照一定的宽高比调整 区块 对象。
      返回一个新的 区块 对象，范围是参数 区块 按照原始 区块 的宽高比调整得来。
      '''
      返回 区块类(自身.rect.fit(区块))

   套路 正常化(自身):
      '''翻转 区块 对象（如果尺寸为负数）。
      如果 宽 或 高 存在负数，则做出相应的翻转，使其变为正数。/n
      翻转后的 区块 仍然在原来的位置，只是修改其相应的属性值。
      '''
      自身.rect.normalize()

   套路 包含检测(自身,*参数)->bool:
      '''检测一个 区块或点 参数是否完全包含在该 区块 对象内。
      参数可以区块类实例 或元组点 或 用两整数表示的点,如 包含检测(区块1) 或 包含检测((x,y)) 或 包含检测(x,y)
      如果 区块或点 参数完全包含在该 区块 对象内,返回 真,否则返回 假
      '''
      如果 len(参数)==1:
         如果 isinstance(参数[0],区块类):
            返回 自身.rect.contains(参数[0].rect)
         如果 isinstance(参数[0],元组):
            返回 自身.rect.collidepoint(参数[0])
      如果 len(参数)==2:
            返回 自身.rect.collidepoint(参数[0],参数[1])   

   套路 重叠检测(自身,目标,标识=1)->bool:
      '''检测 区块\列表或字典中区块 是否任一或全部区块与该区块重叠\n
      参数: 目标,可以为区块类实例 或包含区块实例的列表或字典\n
      参数: 标识,默认1,表示区块与列表或字典中任一区块发生重叠;2,表示区块与列表或字典中全体区块发生重叠\n
      返回: 如参数:目标,是区块时,发生重叠,返回 真,否则返回 假\n
            如参数:目标,是列表时,发生重叠,返回一个包含重叠区块索引的列表,没有发生重叠,则返回空
            如参数:目标,是字典时,发生重叠,返回一个包含重叠区块的字典,没有发生重叠,则返回空
      '''
      如果 isinstance(目标,区块类):
         返回 自身.rect.colliderect(目标.rect)
      如果 isinstance(目标,列表):
         如果 标识==1:
            返回 自身.rect.collidelist(列表型(值.rect 取 值 于 目标))
         或如 标识==2:
            返回 自身.rect.collidelistall(列表型(值.rect 取 值 于 目标))
      如果 isinstance(目标,字典):
         如果 标识==1:
            返回 自身.rect.collidedict(字典型([值, 键] 取 键, 值 于 目标.项()))
         或如 标识==2:
            返回 自身.rect.collidedictall(字典型([值, 键] 取 键, 值 于 目标.项()))