"""
对经典的pygame库进行汉化封装
参考链接:
https://www.pygame.org/docs/
https://blog.csdn.net/qq_41556318/category_9283450.html
"""

_英文版本 = "pygame 2.1.2"
_汉化版本 = "0.2.212"
_汉化人 = "方海飞|fanghaifei@163.com"
_tg_类 = ['颜色类', '显示类', '绘画类','事件类','字体类','图像类','键盘类','鼠标类','混音器类',
'时间类','精灵类','变形类','表层类','区块类']


从 pygame.locals 导入 *
导入 pygame
从 游戏派.类库.绘画 导入 绘画汉化类
从 游戏派.类库.显示 导入 显示汉化类
从 游戏派.类库.事件 导入 事件汉化类
从 游戏派.类库.字体 导入 字体汉化类
从 游戏派.类库.图像 导入 图像汉化类
从 游戏派.类库.键盘 导入 键盘汉化类
从 游戏派.类库.鼠标 导入 鼠标汉化类
从 游戏派.类库.混音器 导入 混音器汉化类
从 游戏派.类库.时间 导入 时间汉化类
从 游戏派.类库.精灵 导入 精灵汉化类
从 游戏派.类库.变形 导入 变形汉化类
从 游戏派.类库.颜色 导入 颜色类
从 游戏派.类库.表层 导入 表层类
从 游戏派.类库.区块 导入 区块类

绘画 = 绘画汉化类()
显示 = 显示汉化类()
事件 = 事件汉化类()
字体 = 字体汉化类()
图像 = 图像汉化类()
键盘 = 键盘汉化类()
鼠标 = 鼠标汉化类()
混音器 = 混音器汉化类()
时间 = 时间汉化类()
精灵 = 精灵汉化类()
变形 = 变形汉化类()

离开 = pygame.QUIT
退出 = exit
用户事件 = pygame.USEREVENT
错误 = pygame.error

套路 初始化()->元组型:
    '''初始化所有导入的游戏派模块\n
    参数: 空\n
    返回: 一个元组，第一个元素为成功导入的模块数，第二个元素为导入失败的个数
    '''       
    返回 pygame.init()

套路 卸载()->元组型:
    '''卸载所有之前被初始化的游戏派模块,但不会结束你的程序\n
    参数: 空\n
    返回: 空
    '''       
    返回 pygame.quit()

套路 获取错误():
    '''获取当前错误信息\n
    参数: 空\n
    返回: 获取 SDL 维护的一个内部错误字符串消息
    '''       
    返回 pygame.get_error()

套路 设置错误(错误信息):
    '''设置当前错误信息\n
    参数: <错误信息>,字符串型\n
    返回: 设置 SDL 维护的一个内部错误字符串消息
    '''       
    pygame.set_error(错误信息)

套路 获取SDL版本():
    '''获取当前错误信息\n
    参数: 空\n
    返回: 获得 SDL 的版本号,字符串型
    '''       
    返回 pygame.get_sdl_version()

套路 获取字节顺序():
    '''获得 SDL 的字节顺序\n
    参数: 空\n
    返回: LIL_ENDIAN 表示小端字节顺序,BIG_ENDIAN 表示大端字节顺序.数字类型
    '''       
    返回 pygame.get_sdl_byteorder()

套路 注册退出套路数(套路数):
    '''注册一个套路数，这个套路数将在游戏派退出时被调用\n
    参数: <套路数>,回调套路数\n
    返回: 空
    '''       
    pygame.register_quit()

套路 检测初始化():
    '''检测初始化状态\n
    参数: 空\n
    返回: 如果游戏派已初始化，则返回真,否则返回假。
    '''       
    返回 pygame.get_init()       

套路 字节编码(*参数):
    '''对 unicode 或字节对象进行编码\n
    参数: unicode类型或bytes类型
    返回: 编码
    '''       
    返回 pygame.encode_string(*参数)

套路 编码文件路径(*参数):
    '''将 unicode 或 bytes 对象编码为文件系统路径\n
    参数: unicode类型或bytes类型
    返回: 文件系统路径
    '''       
    返回 pygame.encode_string(*参数)



