# zwpygame

#### 介绍
pygame游戏编程的草蟒汉化版本,带来强大易懂的中文游戏编程体验.



#### 安装方法

`python -m pip install -U grasspy-pygame

#### 使用说明
```python

#童年的回忆：掌上赛车游戏

从 随机数 导入 随机整数
导入 游戏派

游戏派.初始化()
游戏派.显示.设置标题栏("掌上赛车")
屏幕尺寸 = (320, 400)
黑色 = (0, 0, 0)
白色 = (250, 250, 250)
蓝色 = (0, 255, 255)
红色 = (255, 0, 0)
绿色 = (0, 255, 0)
橙色 = (255, 128, 64)
暗绿色 = (0, 64, 0)
网格宽度 = 20
网格高度 = 20

#   初始化游戏状态：1/游戏开始界面 2/游戏进行中 3/游戏结束
状态 = 1
障碍物列表 = []
斑马线列表 = []
得分 = 0

加速度 = 4 
时钟 = 游戏派.时间.时钟类()
屏幕 = 游戏派.显示.设置模式(屏幕尺寸, 0, 32)
类 障碍物类:

    套路 __初始化__(自身):

        自身.通道_x = 随机整数(0,屏幕尺寸[0] + 1)
        自身.y = 0
        自身.通道宽度 = 随机整数(4,10) * 网格宽度
        自身.间距 = 随机整数(10,10) * 网格高度
        自身.高度 = 随机整数(5,20) / 10 * 网格高度
        自身.右位置 = (0,0)
        自身.左位置 = (0,0)
        自身.颜色 = 橙色
        自身.底部y = 自身.y + 自身.高度

    套路 下沉(自身):
        自身.y += 1 * 加速度

    套路 绘制(自身):

        如果 自身.通道_x == 0:
            自身.右位置 = (自身.通道宽度,自身.y)
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(自身.右位置,(屏幕尺寸[0]-自身.通道宽度,自身.高度)))
        或如 自身.通道_x == 屏幕尺寸[0]:
            自身.左位置 = (0,自身.y)
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(自身.左位置,(屏幕尺寸[0]-自身.通道宽度,自身.高度)))
        或如 自身.通道_x + 自身.通道宽度 > 屏幕尺寸[0]:
            自身.左位置 = (0,自身.y)
            自身.右位置 = (自身.通道_x,自身.y)
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(自身.左位置,(自身.通道_x-自身.通道宽度,自身.高度)))
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(自身.右位置,(屏幕尺寸[0]-自身.通道宽度,自身.高度)))
        否则:
            自身.左位置 = (0,自身.y)
            自身.右位置 = (自身.通道_x + 自身.通道宽度,自身.y)
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(自身.左位置,(自身.通道_x,自身.高度)))
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(自身.右位置,(屏幕尺寸[0]-自身.右位置[0],自身.高度)))     

    套路 更新(自身):
        全局 得分,状态
        自身.下沉()
        如果 自身.y == 自身.间距:
            障碍物列表.追加(障碍物类())
        如果 自身.y > 屏幕尺寸[1]:
            删 障碍物列表[0]
            得分 += 1
        底部y = 自身.y + 自身.高度

        汽车位置x = 汽车.x
        汽车位置y = 汽车.y
        汽车宽度 = 汽车.宽度

        如果 汽车位置y <= 底部y <= 汽车位置y+3*网格高度:

            如果 自身.通道_x == 0:
                如果 自身.通道_x<= 汽车位置x <= 自身.通道_x+自身.通道宽度-汽车宽度:
                    无操作
                否则:
                    状态 = 3
            或如 自身.通道_x == 屏幕尺寸[0]:
                如果 屏幕尺寸[0]-自身.通道宽度<=汽车位置x<=屏幕尺寸[0]-汽车宽度:
                    无操作
                否则:
                    状态 = 3
            或如 自身.通道_x + 自身.通道宽度 > 320:
                如果 自身.通道_x - 自身.通道宽度<= 汽车位置x <= 自身.通道_x-汽车宽度:
                    无操作
                否则:
                    状态 = 3
            否则:
                如果 自身.通道_x <= 汽车位置x <= 自身.通道_x + 自身.通道宽度 - 汽车宽度:
                    无操作
                否则:
                    状态 = 3

障碍物列表.追加(障碍物类())

类 汽车类():
    套路 __初始化__(自身):
        自身.宽度 = 网格宽度 * 3
        自身.高度 = 网格高度 * 4
        自身.x = 屏幕尺寸[0] / 2 -(网格宽度 + 网格宽度 / 2)
        自身.y = 屏幕尺寸[1] - 网格高度 * 4
        自身.速度 = 5
        自身.颜色 = 绿色

    套路 左移(自身):
        自身.x -= 2 * 自身.速度
        自身.x = 最大值(0,自身.x)

    套路 右移(自身):
        自身.x += 2* 自身.速度
        自身.x = 最小值(屏幕尺寸[0] - 网格宽度 * 3,自身.x) 

    套路 更新位置(自身):
        点1 = (自身.x+网格宽度,自身.y)
        点2 = (自身.x,网格高度+自身.y)
        点3 = (自身.x+网格宽度,自身.y+网格高度)
        点4 = (自身.x+网格宽度*2,自身.y+网格高度)
        点5 = (自身.x+网格宽度,自身.y+网格高度*2)
        点6 = (自身.x,自身.y+网格高度*3)
        点7 = (自身.x+网格宽度,自身.y+网格高度*3)
        点8 = (自身.x+网格宽度*2,自身.y+网格高度*3)
        点列表 = [点1,点2,点3,点4,点5,点6,点7,点8]
        返回 点列表
    
    套路 绘制(自身,点列表):
        取 点 于 点列表:
            游戏派.绘画.矩形(屏幕,自身.颜色,游戏派.区块类(点,(网格宽度,网格高度)))

汽车 = 汽车类()

类 斑马线类():

    套路 __初始化__(自身):

        自身.高度 = 5 * 网格高度
        自身.宽度 = 3 * 网格高度
        自身.x,自身.y = (0,0)
        自身.中间区块x = 屏幕尺寸[0]/2 - 网格宽度/2
        自身.中间区块y = 自身.y + (网格高度+网格高度/2) 
    
    套路 绘制(自身):
        左虚线x = 屏幕尺寸[0]/2 - (网格宽度+网格宽度/2) 
        右虚线x = 屏幕尺寸[0]/2 + (网格宽度+网格宽度/2) 
        虚线高 = 自身.y + 5 * 网格高度

        取 i 于 范围(自身.y,虚线高+1,网格高度 * 2):
            游戏派.绘画.直线(屏幕,白色,(左虚线x,i),(左虚线x,i+网格高度))
            游戏派.绘画.直线(屏幕,白色,(右虚线x,i),(右虚线x,i+网格高度))

        中间区块宽度 = 网格宽度
        中间区块高度 = 网格高度 * 2
        游戏派.绘画.矩形(屏幕,白色,游戏派.区块类((自身.中间区块x,自身.中间区块y),(中间区块宽度,中间区块高度)))

    套路 更新(自身): 
        自身.y += 1* 加速度
        自身.中间区块y = 自身.y + (网格高度+网格高度/2)
        如果 自身.y == 自身.高度:
            斑马线列表.追加(斑马线类())
        如果 自身.y > 屏幕尺寸[1]:
            删 斑马线列表[0]

斑马线列表.追加(斑马线类())

类 游戏主体类():

    套路 检测退出():
        全局 状态,得分,汽车,障碍物列表
        取 事件 于 游戏派.事件.获取():
            如果 事件.类型 == 游戏派.离开:
                游戏派.卸载()
                游戏派.退出()
            如果 事件.类型 == 游戏派.KEYDOWN:
                如果 事件.键 == 游戏派.K_ESCAPE:
                    游戏派.卸载()
                    游戏派.退出()
                或如 事件.键 == 游戏派.K_SPACE:
                    如果 状态 == 1:
                        状态 = 2
                    或如 状态 == 3:
                        得分 = 0
                        障碍物列表 =[]
                        汽车 = 汽车类()
                        障碍物列表.追加(障碍物类())
                        状态 = 2

    套路 开始菜单():
        字体 = 游戏派.字体.系统字体("STLITI",25)
        字体表层 = 字体.描绘("空格开始,a键向左,d键向右",真,蓝色)
        屏幕.贴图(字体表层,(屏幕尺寸[0]/2-字体表层.获取宽度()/2,屏幕尺寸[1]/2-字体表层.获取高度()/2))
    
    套路 结束菜单():
        得分字体 = 游戏派.字体.系统字体("STLITI",30)
        重启字体 = 游戏派.字体.系统字体("STLITI",30,5)
        得分字体表层 = 得分字体.描绘("成绩:%d" % 得分, 真, 红色)
        重启字体表层 = 重启字体.描绘(u"重新开始", 真, 红色)

        区块宽度 = 最大值(得分字体表层.获取宽度(),重启字体表层.获取宽度())
        区块高度 = 得分字体表层.获取高度()+重启字体表层.获取高度()

        区块x = 屏幕尺寸[0]/2-区块宽度 /2
        区块y = 屏幕尺寸[1]/2-区块高度 /2

        游戏派.绘画.矩形(屏幕,绿色,游戏派.区块类((区块x,区块y),(区块宽度,区块高度)))
        屏幕.贴图(得分字体表层,(屏幕尺寸[0]/2-得分字体表层.获取宽度()/2,区块y))
        屏幕.贴图(重启字体表层,(屏幕尺寸[0]/2-重启字体表层.获取宽度()/2,区块y+得分字体表层.获取高度()))

    只要 真:
        检测退出()

        如果 状态 == 1:
            开始菜单()
        如果 状态 == 2:
            汽车点列表 = 汽车.更新位置()
            按键 = 游戏派.键盘.获取按键()
            如果 按键[4]:
                汽车.左移()
                汽车点列表 = 汽车.更新位置()
            或如 按键[7]:
                汽车.右移()
                汽车点列表 = 汽车.更新位置()
 
            屏幕.填充(黑色)

            取 斑马线 于 斑马线列表:
                斑马线.更新()
                斑马线.绘制()
                
            取 障碍物 于 障碍物列表:
                障碍物.更新()
                障碍物.绘制()

            汽车.绘制(汽车点列表)
        如果 状态 == 3:
            结束菜单()

        时钟.设置帧率(60)
        游戏派.显示.更新()

游戏主体类()


```
![avatar](1.png)
