"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const eks = require("../lib");
const k8s_patch_1 = require("../lib/k8s-patch");
module.exports = {
    'applies a patch to k8s'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const cluster = new eks.Cluster(stack, 'MyCluster');
        // WHEN
        new k8s_patch_1.KubernetesPatch(stack, 'MyPatch', {
            cluster,
            applyPatch: { patch: { to: 'apply' } },
            restorePatch: { restore: { patch: 123 } },
            resourceName: 'myResourceName',
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('Custom::AWSCDK-EKS-KubernetesPatch', {
            ServiceToken: {
                "Fn::GetAtt": [
                    "awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B",
                    "Outputs.awscdkawseksKubectlProviderframeworkonEvent0A650005Arn"
                ]
            },
            ResourceName: "myResourceName",
            ResourceNamespace: "default",
            ApplyPatchJson: "{\"patch\":{\"to\":\"apply\"}}",
            RestorePatchJson: "{\"restore\":{\"patch\":123}}",
            ClusterName: {
                Ref: "MyCluster8AD82BF8"
            },
            RoleArn: {
                "Fn::GetAtt": [
                    "MyClusterCreationRoleB5FA4FF3",
                    "Arn"
                ]
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5rOHMtcGF0Y2guanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0Lms4cy1wYXRjaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsNENBQXVEO0FBQ3ZELHdDQUFzQztBQUV0Qyw4QkFBOEI7QUFDOUIsZ0RBQW1EO0FBRW5ELGlCQUFTO0lBQ1Asd0JBQXdCLENBQUMsSUFBVTtRQUNqQyxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLEVBQUUsQ0FBQztRQUMxQixNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBRXBELE9BQU87UUFDUCxJQUFJLDJCQUFlLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtZQUNwQyxPQUFPO1lBQ1AsVUFBVSxFQUFFLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLE9BQU8sRUFBRSxFQUFFO1lBQ3RDLFlBQVksRUFBRSxFQUFFLE9BQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsRUFBQztZQUN4QyxZQUFZLEVBQUUsZ0JBQWdCO1NBQy9CLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMsb0NBQW9DLEVBQUU7WUFDbEUsWUFBWSxFQUFFO2dCQUNaLFlBQVksRUFBRTtvQkFDWiw4RkFBOEY7b0JBQzlGLGdFQUFnRTtpQkFDakU7YUFDRjtZQUNELFlBQVksRUFBRSxnQkFBZ0I7WUFDOUIsaUJBQWlCLEVBQUUsU0FBUztZQUM1QixjQUFjLEVBQUUsZ0NBQWdDO1lBQ2hELGdCQUFnQixFQUFFLCtCQUErQjtZQUNqRCxXQUFXLEVBQUU7Z0JBQ1gsR0FBRyxFQUFFLG1CQUFtQjthQUN6QjtZQUNELE9BQU8sRUFBRTtnQkFDUCxZQUFZLEVBQUU7b0JBQ1osK0JBQStCO29CQUMvQixLQUFLO2lCQUNOO2FBQ0Y7U0FDRixDQUFDLENBQUMsQ0FBQztRQUNKLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZXhwZWN0LCBoYXZlUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgKiBhcyBla3MgZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IEt1YmVybmV0ZXNQYXRjaCB9IGZyb20gJy4uL2xpYi9rOHMtcGF0Y2gnO1xuXG5leHBvcnQgPSB7XG4gICdhcHBsaWVzIGEgcGF0Y2ggdG8gazhzJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuICAgIGNvbnN0IGNsdXN0ZXIgPSBuZXcgZWtzLkNsdXN0ZXIoc3RhY2ssICdNeUNsdXN0ZXInKTtcblxuICAgIC8vIFdIRU5cbiAgICBuZXcgS3ViZXJuZXRlc1BhdGNoKHN0YWNrLCAnTXlQYXRjaCcsIHtcbiAgICAgIGNsdXN0ZXIsXG4gICAgICBhcHBseVBhdGNoOiB7IHBhdGNoOiB7IHRvOiAnYXBwbHknIH0gfSxcbiAgICAgIHJlc3RvcmVQYXRjaDogeyByZXN0b3JlOiB7IHBhdGNoOiAxMjMgfX0sXG4gICAgICByZXNvdXJjZU5hbWU6ICdteVJlc291cmNlTmFtZScsXG4gICAgfSk7XG5cbiAgICAvLyBUSEVOXG4gICAgZXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0N1c3RvbTo6QVdTQ0RLLUVLUy1LdWJlcm5ldGVzUGF0Y2gnLCB7XG4gICAgICBTZXJ2aWNlVG9rZW46IHtcbiAgICAgICAgXCJGbjo6R2V0QXR0XCI6IFtcbiAgICAgICAgICBcImF3c2Nka2F3c2Vrc0t1YmVjdGxQcm92aWRlck5lc3RlZFN0YWNrYXdzY2RrYXdzZWtzS3ViZWN0bFByb3ZpZGVyTmVzdGVkU3RhY2tSZXNvdXJjZUE3QUVCQTZCXCIsXG4gICAgICAgICAgXCJPdXRwdXRzLmF3c2Nka2F3c2Vrc0t1YmVjdGxQcm92aWRlcmZyYW1ld29ya29uRXZlbnQwQTY1MDAwNUFyblwiXG4gICAgICAgIF1cbiAgICAgIH0sXG4gICAgICBSZXNvdXJjZU5hbWU6IFwibXlSZXNvdXJjZU5hbWVcIixcbiAgICAgIFJlc291cmNlTmFtZXNwYWNlOiBcImRlZmF1bHRcIixcbiAgICAgIEFwcGx5UGF0Y2hKc29uOiBcIntcXFwicGF0Y2hcXFwiOntcXFwidG9cXFwiOlxcXCJhcHBseVxcXCJ9fVwiLFxuICAgICAgUmVzdG9yZVBhdGNoSnNvbjogXCJ7XFxcInJlc3RvcmVcXFwiOntcXFwicGF0Y2hcXFwiOjEyM319XCIsXG4gICAgICBDbHVzdGVyTmFtZToge1xuICAgICAgICBSZWY6IFwiTXlDbHVzdGVyOEFEODJCRjhcIlxuICAgICAgfSxcbiAgICAgIFJvbGVBcm46IHtcbiAgICAgICAgXCJGbjo6R2V0QXR0XCI6IFtcbiAgICAgICAgICBcIk15Q2x1c3RlckNyZWF0aW9uUm9sZUI1RkE0RkYzXCIsXG4gICAgICAgICAgXCJBcm5cIlxuICAgICAgICBdXG4gICAgICB9XG4gICAgfSkpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9XG59OyJdfQ==