"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const eks = require("../lib");
const util_1 = require("./util");
class MyStack extends util_1.TestStack {
    constructor(scope, id) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'vpc', { maxAzs: 2 });
        // two on-demand instances
        const cluster = new eks.Cluster(this, 'myCluster', {
            defaultCapacity: 2,
            vpc,
        });
        // up to ten spot instances
        cluster.addCapacity('spot', {
            spotPrice: '0.1094',
            instanceType: new ec2.InstanceType('t3.large'),
            maxCapacity: 10,
            bootstrapOptions: {
                kubeletExtraArgs: '--node-labels foo=bar,goo=far',
                awsApiRetryAttempts: 5
            }
        });
    }
}
const app = new core_1.App();
new MyStack(app, 'integ-eks-spot');
app.synth();
//# sourceMappingURL=data:application/json;base64,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