"use strict";
/// !cdk-integ *
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const util_1 = require("./util");
class VpcStack extends util_1.TestStack {
    constructor(scope, id) {
        super(scope, id);
        this.vpc = new ec2.Vpc(this, 'vpc', { maxAzs: 2 });
    }
}
class ClusterStack extends util_1.TestStack {
    constructor(scope, id, props) {
        super(scope, id);
        /// !show
        // define the cluster. kubectl is enabled by default.
        this.cluster = new lib_1.Cluster(this, 'cluster22', {
            vpc: props.vpc,
            defaultCapacity: 0,
        });
        // define an IAM role assumable by anyone in the account and map it to the k8s
        // `system:masters` group this is required if you want to be able to issue
        // manual `kubectl` commands against the cluster.
        const mastersRole = new iam.Role(this, 'AdminRole', { assumedBy: new iam.AccountRootPrincipal() });
        this.cluster.awsAuth.addMastersRole(mastersRole);
        // add some capacity to the cluster. The IAM instance role will
        // automatically be mapped via aws-auth to allow nodes to join the cluster.
        this.cluster.addCapacity('Nodes', {
            instanceType: new ec2.InstanceType('t2.medium'),
            minCapacity: 3,
        });
        // add two Helm charts to the cluster. This will be the Kubernetes dashboard and the Nginx Ingress Controller
        this.cluster.addChart('dashboard', { chart: 'kubernetes-dashboard', repository: 'https://kubernetes-charts.storage.googleapis.com' });
        this.cluster.addChart('nginx-ingress', { chart: 'nginx-ingress', repository: 'https://helm.nginx.com/stable', namespace: 'kube-system' });
        /// !hide
    }
}
const app = new core_1.App();
const vpcStack = new VpcStack(app, 'k8s-vpc');
new ClusterStack(app, 'k8s-cluster', { vpc: vpcStack.vpc });
app.synth();
//# sourceMappingURL=data:application/json;base64,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