"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const eks = require("../lib");
const hello = require("./hello-k8s");
class FargateTest extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // allow all account users to assume this role in order to admin the cluster
        const mastersRole = new iam.Role(this, 'AdminRole', {
            assumedBy: new iam.AccountRootPrincipal()
        });
        const cluster = new eks.FargateCluster(this, 'MyCluster', {
            mastersRole
        });
        cluster.addResource('HelloApp', ...hello.resources);
        //
        // bear in mind that since Fargate doesn't yet support NLB/CLB, you will only
        // be able to access this service from within the cluster or through a kubectl proxy:
        //
        // start the proxy:
        //    $ kubectl proxy
        //    Starting to serve on 127.0.0.1:8001
        //
        // and then (in another terminal):
        //    $ curl -L http://localhost:8001/api/v1/namespaces/default/services/hello-kubernetes/proxy
        //    <html>....
        //
    }
}
const app = new core_1.App();
new FargateTest(app, 'fargate-integ-test');
app.synth();
//# sourceMappingURL=data:application/json;base64,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