"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const crypto = require("crypto");
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '1.13.7';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest("hex");
        const version = props.version || KUBECTL_APP_VERSION;
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: KUBECTL_APP_ARN,
                    SemanticVersion: version
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`
                }
            }
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    /**
     * Gets or create a singleton instance of this construct.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const id = 'kubectl-layer-' + (props.version ? props.version : "8C2542BC-BF2B-4DFE-B765-E181FD30A9A0");
        const exists = stack.node.tryFindChild(id);
        if (exists) {
            return exists;
        }
        return new KubectlLayer(stack, id, props);
    }
    get stack() {
        return core_1.Stack.of(this);
    }
    addPermission(_id, _permission) {
        return;
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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