# morals-streams-api
API that provides access to Moralis Streams

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import moralis_streams_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import moralis_streams_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import moralis_streams_api
from moralis_streams_api.rest import ApiException
from pprint import pprint

# Configure API key authorization: x-api-key
configuration = moralis_streams_api.Configuration()
configuration.api_key['x-api-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-api-key'] = 'Bearer'

# create an instance of the API class
api_instance = moralis_streams_api.BetaApi(moralis_streams_api.ApiClient(configuration))

try:
    api_response = api_instance.get_stats()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BetaApi->get_stats: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BetaApi* | [**get_stats**](docs/BetaApi.md#get_stats) | **GET** /beta/stats | 
*EVMStreamsApi* | [**add_address_to_stream**](docs/EVMStreamsApi.md#add_address_to_stream) | **POST** /streams/evm/{id}/address | 
*EVMStreamsApi* | [**create_stream**](docs/EVMStreamsApi.md#create_stream) | **PUT** /streams/evm | 
*EVMStreamsApi* | [**delete_address_from_stream**](docs/EVMStreamsApi.md#delete_address_from_stream) | **DELETE** /streams/evm/{id}/address | 
*EVMStreamsApi* | [**delete_stream**](docs/EVMStreamsApi.md#delete_stream) | **DELETE** /streams/evm/{id} | 
*EVMStreamsApi* | [**get_addresses**](docs/EVMStreamsApi.md#get_addresses) | **GET** /streams/evm/{id}/address | 
*EVMStreamsApi* | [**get_stream**](docs/EVMStreamsApi.md#get_stream) | **GET** /streams/evm/{id} | 
*EVMStreamsApi* | [**get_streams**](docs/EVMStreamsApi.md#get_streams) | **GET** /streams/evm | 
*EVMStreamsApi* | [**update_stream**](docs/EVMStreamsApi.md#update_stream) | **POST** /streams/evm/{id} | 
*EVMStreamsApi* | [**update_stream_status**](docs/EVMStreamsApi.md#update_stream_status) | **POST** /streams/evm/{id}/status | 
*HistoryApi* | [**get_history**](docs/HistoryApi.md#get_history) | **GET** /history | 
*HistoryApi* | [**replay_history**](docs/HistoryApi.md#replay_history) | **POST** /history/replay/{id} | 
*ProjectApi* | [**get_settings**](docs/ProjectApi.md#get_settings) | **GET** /settings | 
*ProjectApi* | [**set_settings**](docs/ProjectApi.md#set_settings) | **POST** /settings | 

## Documentation For Models

 - [AbiInput](docs/AbiInput.md)
 - [AbiItem](docs/AbiItem.md)
 - [AbiOutput](docs/AbiOutput.md)
 - [Addresses](docs/Addresses.md)
 - [AddressesTypesAddressResponse](docs/AddressesTypesAddressResponse.md)
 - [AddressesTypesAddressesAdd](docs/AddressesTypesAddressesAdd.md)
 - [AddressesTypesAddressesRemove](docs/AddressesTypesAddressesRemove.md)
 - [AddressesTypesAddressesResponse](docs/AddressesTypesAddressesResponse.md)
 - [AddressesTypesDeleteAddressResponse](docs/AddressesTypesDeleteAddressResponse.md)
 - [AddressesTypesUUID](docs/AddressesTypesUUID.md)
 - [AdvancedOptions](docs/AdvancedOptions.md)
 - [AnyOfaddressesTypesAddressResponseAddress](docs/AnyOfaddressesTypesAddressResponseAddress.md)
 - [AnyOfaddressesTypesAddressesAddAddress](docs/AnyOfaddressesTypesAddressesAddAddress.md)
 - [Block](docs/Block.md)
 - [HistoryModel](docs/HistoryModel.md)
 - [HistoryTypesHistoryModel](docs/HistoryTypesHistoryModel.md)
 - [HistoryTypesHistoryResponse](docs/HistoryTypesHistoryResponse.md)
 - [HistoryTypesUUID](docs/HistoryTypesUUID.md)
 - [IAbi](docs/IAbi.md)
 - [IERC20Approval](docs/IERC20Approval.md)
 - [IERC20Transfer](docs/IERC20Transfer.md)
 - [INFTApproval](docs/INFTApproval.md)
 - [INFTApprovalERC1155](docs/INFTApprovalERC1155.md)
 - [INFTApprovalERC721](docs/INFTApprovalERC721.md)
 - [INFTTransfer](docs/INFTTransfer.md)
 - [InternalTransaction](docs/InternalTransaction.md)
 - [Log](docs/Log.md)
 - [PartialStreamsTypesStreamsModelCreate_](docs/PartialStreamsTypesStreamsModelCreate_.md)
 - [SettingsRegion](docs/SettingsRegion.md)
 - [SettingsTypesSettingsModel](docs/SettingsTypesSettingsModel.md)
 - [StatsTypesStatsModel](docs/StatsTypesStatsModel.md)
 - [StreamsFilter](docs/StreamsFilter.md)
 - [StreamsModel](docs/StreamsModel.md)
 - [StreamsStatus](docs/StreamsStatus.md)
 - [StreamsTypesStreamsModel](docs/StreamsTypesStreamsModel.md)
 - [StreamsTypesStreamsModelCreate](docs/StreamsTypesStreamsModelCreate.md)
 - [StreamsTypesStreamsResponse](docs/StreamsTypesStreamsResponse.md)
 - [StreamsTypesStreamsStatusUpdate](docs/StreamsTypesStreamsStatusUpdate.md)
 - [StreamsTypesUUID](docs/StreamsTypesUUID.md)
 - [Transaction](docs/Transaction.md)
 - [UUID](docs/UUID.md)
 - [WebhookTypesIWebhook](docs/WebhookTypesIWebhook.md)

## Documentation For Authorization


## x-api-key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author


