# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/Client.ipynb (unless otherwise specified).

__all__ = ["Client", "DataBlob", "DataSource", "User", "APIKey"]

# Cell

from typing import *
import types
import inspect

import typer
import airt

from airt.constant import *

# Internal Cell


def _replace_env_var(s: str) -> str:
    return s.replace("AIRT_", "CAPTN_").replace("airt", "captn")


# Internal Cell


def _fix_doc_string(cls: Type):

    cls.__doc__ = _replace_env_var(cls.__doc__)  # type: ignore

    for i in dir(cls):

        attr = getattr(cls, i)

        if (attr) and (not i.startswith("_")):
            for a in [attr, inspect.unwrap(attr)]:
                try:
                    if a.__class__ == types.MethodType:
                        a.__func__.__doc__ = _replace_env_var(a.__func__.__doc__)
                    else:
                        a.__doc__ = _replace_env_var(a.__doc__)

                except Exception as e:  # nosec B110
                    pass

                for ref in ["AIRT_", "airt"]:
                    if ref in a.__doc__:
                        raise ValueError(f"{ref} reference is available in {a.__doc__}")


# Internal Cell


def _fix_cli_doc_string(app: typer.Typer, m_name: str):
    for c in app.registered_commands:
        name = c.callback.__name__.replace("-", "_")  # type: ignore

        getattr(getattr(airt.cli, m_name), name).__doc__ = _replace_env_var(
            getattr(getattr(airt.cli, m_name), name).__doc__
        )


# Internal Cell


def _set_global_env_vars(m: types.ModuleType):
    for v in dir(m):
        if not v.startswith("_"):
            setattr(m, v, _replace_env_var(getattr(m, v)))

            if "AIRT_" in getattr(m, v):
                raise ValueError(f"AIRT_ reference is available in {getattr(m, v)}")


# Cell

_set_global_env_vars(airt.constant)

from airt.client import Client as _Client

Client = _Client

from airt.client import DataBlob as _DataBlob

DataBlob = _DataBlob

from airt.client import DataSource as _DataSource

DataSource = _DataSource

from airt.client import User as _User

User = _User

from airt.client import APIKey as _APIKey

APIKey = _APIKey

for cls in [Client, DataBlob, DataSource, User, APIKey]:
    cls.__module__ = "captn.client"
    _fix_doc_string(cls)
