# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/shift.ipynb (unless otherwise specified).

__all__ = ['shift_array']

# Cell
import numpy as np
from numba import njit  # type: ignore

# Cell
@njit
def shift_array(input_array: np.ndarray, offset: int) -> np.ndarray:
    n_samples = input_array.size
    output_array = np.full_like(input_array, np.nan)
    for i in range(n_samples - offset):
        output_array[i + offset] = input_array[i]
    return output_array