<div align="center" id="top">
  <img src="./.github/app.gif" alt="Eclectic" />

  &#xa0;

  <!-- <a href="https://eclectic.netlify.app">Demo</a> -->
</div>

<h1 align="center">Eclectic: Python Web Framework built for real projects</h1>


<p align="center">

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg)](code_of_conduct.md)
![GitHub](https://img.shields.io/github/license/eclecticlly/eclectic)
![PyPI](https://img.shields.io/pypi/v/eclectic.svg)
![purpose](https://img.shields.io/badge/purpose-learning%20%26%20real%20projects-informational.svg)
</p>

<!-- Status -->

<h4 align="center">
	🚧  Eclectic 🚀 Under construction...Docs arrives soon  🚧
</h4>

<hr>

<p align="center">
  <a href="#dart-about">About</a> &#xa0; | &#xa0;
  <a href="#sparkles-features">Features</a> &#xa0; | &#xa0;
  <a href="#rocket-technologies">Technologies</a> &#xa0; | &#xa0;
  <a href="#checkered_flag-installation">Installation</a> &#xa0; | &#xa0;
  <a href="#memo-license">License</a> &#xa0; | &#xa0;
  <a href="https://github.com/eclecticlly" target="_blank">Author</a>
</p>

<br>

## :dart: About ##

Eclectic is a Python web framework built for learning purposes and evolving for working on real projects.

It's a WSGI framework and can be used with any WSGI application server such as [Gunicorn](https://gunicorn.org/).

## :sparkles: Features ##

:heavy_check_mark: WSGI compatibility\
:heavy_check_mark: Flask and Django style routing.\
:heavy_check_mark: Json / HTML / Text Responses\
:heavy_check_mark: Templates\
:heavy_check_mark: Static Files\
:heavy_check_mark: Middleware\
:heavy_check_mark: Test\
:heavy_check_mark: ORM

## :rocket: Technologies ##

The following tools were used in this project:

- [Parse](https://pypi.org/project/parse/)
- [Jinja2](https://pypi.org/project/Jinja2/)
- [Whitenoise](https://pypi.org/project/whitenoise/)
- [WebOb](https://pypi.org/project/WebOb/)
- [Pytest](https://pypi.org/project/pytest/)
- [Requests](https://pypi.org/project/requests/)
- [Requests-wsgi-adapter](https://pypi.org/project/requests-wsgi-adapter/)

## :checkered_flag: Installation ##

```shell
pip install eclectic
```

## :memo: License ##

This project is under license from MIT. For more details, see the [LICENSE](LICENSE.md) file.


Made with :heart: by <a href="https://github.com/eclecticlly" target="_blank">Eclecticlly</a>

&#xa0;

<a href="#top">Back to top</a>
