# Quantifiles

[![pipeline status](https://gitlab.com/dcrielaard/quantifiles/badges/main/pipeline.svg)](https://gitlab.com/dcrielaard/quantifiles/-/commits/main) 
[![PyPi](https://img.shields.io/pypi/v/quantifiles.svg)](https://pypi.org/pypi/quantifiles)
[![License](https://img.shields.io/badge/License-BSD_2--Clause-blue.svg)](https://opensource.org/licenses/BSD-2-Clause)
[![Code style](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

Welcome to Quantifiles, a PyQt5 application designed for viewing dataset files generated by [Quantify-core](https://gitlab.com/quantify-os/quantify-core/). With Quantifiles, you can easily browse and visualize the contents of your data directory, including the ability to view a plot of the data and browse snapshots.

## Installation

### Install from PyPI

```bash
pip install quantifiles
```

### Install from source

To install Quantifiles from source, first clone the repository:

```bash
git clone https://gitlab.com/dcrielaard/quantifiles.git
cd quantifiles
```

Then, install the application in a virtual environment using pip:
```bash
pip install -e .
```

### Install with pipenv

If you prefer to use pipenv for managing your virtual environment, you can install Quantifiles with the following command:

```bash
pipenv install git+https://gitlab.com/dcrielaard/quantifiles.git#egg=quantifiles
```

## Usage

You can launch the application by running the following command in your terminal:

```bash
quantifiles [--datadir DATADIR] [--liveplotting] [--loglevel LOGLEVEL]
```

If you don't specify the data directory, you can still access it by selecting File->Open in the application.

Alternatively, you can also use the executable file located in the Scripts folder, which will be generated upon installation.

To start the application from within Python, run:

```python
from quantifiles import quantifiles

quantifiles()  # This will start the application, optionally you can pass the data directory as an argument.
```

**Tip:** The plots can be copied to the clipboard by right-clicking on them.

## Contributing

We welcome contributions to Quantifiles! If you have an idea for a feature, or if you encounter a bug, please [open an issue](https://gitlab.com/dcrielaard/quantifiles/issues/new) or submit a pull request.

Feel free to dive in!

## License
This project is licensed under the terms of the BSD 2-Clause License. See the LICENSE file for more details.
