# Contributing to repo2docker development

:sparkles: Thank you for thinking about contributing to repo2docker! :sparkles:

(And thank you particularly for coming to read the guidelines! :heart_eyes:)

The repo2docker developer documentation is all rendered on our documentation website: [https://repo2docker.readthedocs.io](https://repo2docker.readthedocs.io).
If you're here, you're probably looking for the [Contributing to repo2docker development](https://repo2docker.readthedocs.io/en/latest/contributing/contributing.html) page.

Please make sure you've read the following sections before opening an issue/pull request:
* [Process for making a contribution](https://repo2docker.readthedocs.io/en/latest/contributing/contributing.html#process-for-making-a-contribution).
  * These steps talk you through choosing the right issue template (bug report or feature request) and making a change.
* [Guidelines to getting a Pull Request merged](https://repo2docker.readthedocs.io/en/latest/contributing/contributing.html#guidelines-to-getting-a-pull-request-merged).
  * These are tips and tricks to help make your contribution as smooth as possible for you and for the repo2docker maintenance team.

There are a few other pages to highlight:

* [Our roadmap](https://repo2docker.readthedocs.io/en/latest/contributing/roadmap.html)
  * We use the roadmap to develop a shared understanding of the project's vision and direction amongst the community of users, contributors, and maintainers.
    This is a great place to get a feel for what the maintainers are thinking about for the short, medium, and long term future of the project.
* [Design of repo2docker](https://repo2docker.readthedocs.io/en/latest/design.html)
  * This page explains some of the design principles behind repo2docker.
    Its a good place to understand _why_ the team have made the decisions that they have along the way!
  * We absolutely encourage discussion around refactoring, updating or extending repo2docker, but please make sure that you've understood this page before opening an issue to discuss the change you'd like to propose.
* [Common developer tasks and how-tos](https://repo2docker.readthedocs.io/en/latest/contributing/tasks.html)
  * Some notes on running tests, buildpack dependencies, creating a release, updating the changelog and keeping the pip files up to date.
