
#
# RENDERED FOR VERSION: {% VERSION %}
#
# WARNING: This file is autogenerated by the `lily` and any manual
# changes you will apply here will be overwritten by next
# `lily init <project>` invocation.
#

help:  ## show this help.
	@fgrep -h "##" $(MAKEFILE_LIST) | fgrep -v fgrep | sed -e 's/\\$$//' | sed -e 's/##//'

SHELL := /bin/bash

LILY_SERVICE_PORT := $(shell source env.sh && echo $${LILY_SERVICE_PORT})

VERSION := $(shell poetry version -s)

CHROME_EXISTS := $(shell command -v google-chrome)

TEST_COVERAGE_THRESHOLD := 90

#
# LINTER & CODE QUALITY
#
.PHONY: lint
lint:  ## lint the lily & tests
	printf "\n>> [CHECKER] check if code fulfills quality criteria\n" && \
	source env.sh && \
	flake8 --max-line-length 100 --ignore N818,D100,D101,D102,D103,D104,D105,D106,D107,D202,D204,W504,W606 tests && \
	flake8 --max-line-length 100 --ignore N818,D100,D101,D102,D103,D104,D105,D106,D107,D202,D204,W504,W606 {% SRC_DIR %}

#
# TEST LIFECYCLE TARGETS
#
# NOTE: Those targets are only here as place-holders for
# overwrites which will be run pre and post various test targets. See below.
#
.PHONY: test_setup
test_setup:
	printf "\n>> TEST SET UP\n"

.PHONY: test_teardown
test_teardown:
	printf "\n>> TEST TEAR DOWN\n"

# -- TEST SELECTED
.PHONY: test
test:
	printf "\n>> [CHECKER] check if chosen tests are passing\n" && \
	source env.sh && \
	pytest --cov={% SRC_DIR %} --cov-fail-under=${TEST_COVERAGE_THRESHOLD} -r w -s -vv $(tests)

# -- TEST ALL
.PHONY: _test_all
_test_all:
	printf "\n>> [CHECKER] check if all tests are passing\n" && \
	source env.sh && \
	pytest --cov={% SRC_DIR %} --cov-fail-under=${TEST_COVERAGE_THRESHOLD} -r w -s -vv tests && \
    coverage html -d coverage_html

.PHONY: test_all
test_all: test_setup _test_all test_teardown  ## run all available tests

#
# UTILS
#
shell:  ## run django shell (ipython)
	source env.sh && \
	python {% SRC_DIR %}/manage.py shell

#
# MIGRATIONS
#
.PHONY: migrations_create
migrations_create:  ## auto-create migrations for all installed apps
	source env.sh && \
	python {% SRC_DIR %}/manage.py makemigrations

.PHONY: migrations_bulk_read
migrations_bulk_read:  ## real all migrations
	source env.sh && \
	python {% SRC_DIR %}/manage.py showmigrations

.PHONY: migrations_render_current_plan
migrations_render_current_plan:  ## render current plan of running migrations
	source env.sh && \
	python {% SRC_DIR %}/manage.py render_current_migration_plan

.PHONY: migrations_apply_current
migrations_apply_current:  ## apply all not yet applied migrations
	source env.sh && \
	python {% SRC_DIR %}/manage.py migrate

.PHONY: migrations_apply_for_version
migrations_apply_for_version:  ## apply migrations plan for specific version
	source env.sh && \
	python {% SRC_DIR %}/manage.py apply_migration_plan_for_version $(version)

#
# COMMANDS & DOCS
#
.PHONY: docs_render_commands
docs_render_commands:  ## render JSON representation of commands
	source env.sh && \
	python {% SRC_DIR %}/manage.py render_commands


#
# START
#
start_dev_server: migrations_apply_current  ## start development server (for quick checks) locally
	source env.sh && \
	python {% SRC_DIR %}/manage.py runserver 127.0.0.1:${LILY_SERVICE_PORT}

#
# OVERWRITE SETUP / TEARDOWN
#
.PHONY: clear_examples
clear_examples:  ## clear all existing examples
	source env.sh && \
	python {% SRC_DIR %}/manage.py clear_examples


.PHONY: test_setup
test_setup: clear_examples


.PHONY: upgrade_version_post_upgrade
upgrade_version_post_upgrade: docs_render_commands migrations_render_current_plan
