/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.descriptor;

import hex.ModelCategory;
import hex.genmodel.MojoModel;
import hex.genmodel.descriptor.ModelDescriptor;
import java.io.Serializable;
import java.util.Arrays;

public class ModelDescriptorBuilder {
    public static ModelDescriptor makeDescriptor(MojoModel mojoModel, String fullAlgorithmName) {
        return new MojoModelDescriptor(mojoModel, fullAlgorithmName);
    }

    public static class MojoModelDescriptor
    implements ModelDescriptor,
    Serializable {
        private final String _h2oVersion;
        private final ModelCategory _category;
        private final String _uuid;
        private final boolean _supervised;
        private final int _nfeatures;
        private final int _nclasses;
        private final boolean _balanceClasses;
        private final double _defaultThreshold;
        private final double[] _priorClassDistrib;
        private final double[] _modelClassDistrib;
        private final String _offsetColumn;
        private final String[][] _domains;
        private final String[] _names;
        private final String _algoName;
        private final String _fullAlgoName;

        private MojoModelDescriptor(MojoModel mojoModel, String fullAlgorithmName) {
            this._category = mojoModel._category;
            this._uuid = mojoModel._uuid;
            this._supervised = mojoModel.isSupervised();
            this._nfeatures = mojoModel.nfeatures();
            this._nclasses = mojoModel._nclasses;
            this._balanceClasses = mojoModel._balanceClasses;
            this._defaultThreshold = mojoModel._defaultThreshold;
            this._priorClassDistrib = mojoModel._priorClassDistrib;
            this._modelClassDistrib = mojoModel._modelClassDistrib;
            this._h2oVersion = mojoModel._h2oVersion;
            this._offsetColumn = mojoModel._offsetColumn;
            this._domains = mojoModel._domains;
            this._names = mojoModel._names;
            this._algoName = mojoModel._algoName;
            this._fullAlgoName = fullAlgorithmName;
        }

        @Override
        public String[][] scoringDomains() {
            return this._domains;
        }

        @Override
        public String projectVersion() {
            return this._h2oVersion;
        }

        @Override
        public String algoName() {
            return this._algoName;
        }

        @Override
        public String algoFullName() {
            return this._fullAlgoName;
        }

        @Override
        public String offsetColumn() {
            return this._offsetColumn;
        }

        @Override
        public String weightsColumn() {
            return null;
        }

        @Override
        public String foldColumn() {
            return null;
        }

        @Override
        public ModelCategory getModelCategory() {
            return this._category;
        }

        @Override
        public boolean isSupervised() {
            return this._supervised;
        }

        @Override
        public int nfeatures() {
            return this._nfeatures;
        }

        @Override
        public String[] features() {
            return Arrays.copyOf(this.columnNames(), this.nfeatures());
        }

        @Override
        public int nclasses() {
            return this._nclasses;
        }

        @Override
        public String[] columnNames() {
            return this._names;
        }

        @Override
        public boolean balanceClasses() {
            return this._balanceClasses;
        }

        @Override
        public double defaultThreshold() {
            return this._defaultThreshold;
        }

        @Override
        public double[] priorClassDist() {
            return this._priorClassDistrib;
        }

        @Override
        public double[] modelClassDist() {
            return this._modelClassDistrib;
        }

        @Override
        public String uuid() {
            return this._uuid;
        }

        @Override
        public String timestamp() {
            return null;
        }
    }
}

