import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Properties of CloudFront OriginAccessIdentity.
 *
 * @stability stable
 */
export interface OriginAccessIdentityProps {
    /**
     * Any comments you want to include about the origin access identity.
     *
     * @default "Allows CloudFront to reach the bucket"
     * @stability stable
     */
    readonly comment?: string;
}
/**
 * Interface for CloudFront OriginAccessIdentity.
 *
 * @stability stable
 */
export interface IOriginAccessIdentity extends cdk.IResource, iam.IGrantable {
    /**
     * The Origin Access Identity Name.
     *
     * @stability stable
     */
    readonly originAccessIdentityName: string;
}
declare abstract class OriginAccessIdentityBase extends cdk.Resource {
    /**
     * The Origin Access Identity Name (physical id)
     */
    abstract readonly originAccessIdentityName: string;
    /**
     * Derived principal value for bucket access
     */
    abstract readonly grantPrincipal: iam.IPrincipal;
    /**
     * The ARN to include in S3 bucket policy to allow CloudFront access.
     *
     * @stability stable
     */
    protected arn(): string;
}
/**
 * An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content.
 *
 * @stability stable
 * @resource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
export declare class OriginAccessIdentity extends OriginAccessIdentityBase implements IOriginAccessIdentity {
    /**
     * Creates a OriginAccessIdentity by providing the OriginAccessIdentityName.
     *
     * @stability stable
     */
    static fromOriginAccessIdentityName(scope: Construct, id: string, originAccessIdentityName: string): IOriginAccessIdentity;
    /**
     * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3.
     *
     * @stability stable
     * @attribute true
     */
    readonly cloudFrontOriginAccessIdentityS3CanonicalUserId: string;
    /**
     * Derived principal value for bucket access.
     *
     * @stability stable
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * The Origin Access Identity Name (physical id).
     *
     * @stability stable
     * @attribute true
     */
    readonly originAccessIdentityName: string;
    /**
     * CDK L1 resource
     */
    private readonly resource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: OriginAccessIdentityProps);
}
export {};
