"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloneRepository = exports.Ec2Environment = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const cloud9_generated_1 = require("../lib/cloud9.generated");
/**
 * A Cloud9 Environment with Amazon EC2
 * @resource AWS::Cloud9::EnvironmentEC2
 */
class Ec2Environment extends cdk.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_cloud9_Ec2EnvironmentProps(props);
        this.vpc = props.vpc;
        if (!props.subnetSelection && this.vpc.publicSubnets.length === 0) {
            throw new Error('no subnetSelection specified and no public subnet found in the vpc, please specify subnetSelection');
        }
        const vpcSubnets = (_c = props.subnetSelection) !== null && _c !== void 0 ? _c : { subnetType: ec2.SubnetType.PUBLIC };
        const c9env = new cloud9_generated_1.CfnEnvironmentEC2(this, 'Resource', {
            name: props.ec2EnvironmentName,
            description: props.description,
            instanceType: (_e = (_d = props.instanceType) === null || _d === void 0 ? void 0 : _d.toString()) !== null && _e !== void 0 ? _e : ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE2, ec2.InstanceSize.MICRO).toString(),
            subnetId: this.vpc.selectSubnets(vpcSubnets).subnetIds[0],
            repositories: props.clonedRepositories ? props.clonedRepositories.map(r => ({
                repositoryUrl: r.repositoryUrl,
                pathComponent: r.pathComponent,
            })) : undefined,
        });
        this.environmentId = c9env.ref;
        this.ec2EnvironmentArn = c9env.getAtt('Arn').toString();
        this.ec2EnvironmentName = c9env.getAtt('Name').toString();
        this.ideUrl = `https://${this.stack.region}.console.aws.amazon.com/cloud9/ide/${this.environmentId}`;
    }
    /**
     * import from EnvironmentEc2Name
     */
    static fromEc2EnvironmentName(scope, id, ec2EnvironmentName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.ec2EnvironmentName = ec2EnvironmentName;
                this.ec2EnvironmentArn = cdk.Stack.of(this).formatArn({
                    service: 'cloud9',
                    resource: 'environment',
                    resourceName: this.ec2EnvironmentName,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.Ec2Environment = Ec2Environment;
_a = JSII_RTTI_SYMBOL_1;
Ec2Environment[_a] = { fqn: "@aws-cdk/aws-cloud9.Ec2Environment", version: "1.152.0" };
/**
 * The class for different repository providers
 */
class CloneRepository {
    constructor(repositoryUrl, pathComponent) {
        this.repositoryUrl = repositoryUrl;
        this.pathComponent = pathComponent;
    }
    /**
     * import repository to cloud9 environment from AWS CodeCommit
     *
     * @param repository the codecommit repository to clone from
     * @param path  the target path in cloud9 environment
     */
    static fromCodeCommit(repository, path) {
        return {
            repositoryUrl: repository.repositoryCloneUrlHttp,
            pathComponent: path,
        };
    }
}
exports.CloneRepository = CloneRepository;
_b = JSII_RTTI_SYMBOL_1;
CloneRepository[_b] = { fqn: "@aws-cdk/aws-cloud9.CloneRepository", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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