"""
To Install IRAF on Mac
conda config --add channels http://ssb.stsci.edu/astroconda
conda create -n iraf27 python=2.7 iraf-all pyraf-all stsci
conda activate iraf27

The IRAF commands are as follows. Specify xgterm as the terminal type.
$ mkiraf
$ xgterm -fn 10*20 -sbr -e cl
ecl> task $convert_fits = convert_fits.cl
ecl> echo = yes
ecl> convert_fits
"""

from pathlib import Path

in_dir = Path(__file__).parent.parent / 'Spectra'

if __name__ == '__main__':

    file_list = in_dir.glob('*.fits')
    with open('convert_fits.cl', 'w') as ofile:
        for file_path in file_list:
            ofile.write(
                f'wspectext ../Spectra/{file_path.stem}.fits[*,1] {file_path.stem}.txt header=no\n'
            )
