"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteBucket = void 0;
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class WebsiteBucket extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { bucketName, removalPolicy = core_1.RemovalPolicy.RETAIN, disableUpload = false, source, websiteIndexDocument, websiteErrorDocument } = props;
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            bucketName,
            removalPolicy,
            websiteIndexDocument: websiteIndexDocument || 'index.html',
            websiteErrorDocument: websiteErrorDocument || 'error.html',
        });
        if (removalPolicy === core_1.RemovalPolicy.DESTROY) {
            new cdk_deletable_bucket_1.EmptyBucket(this, 'EmptyBucket', {
                bucket,
            });
        }
        const originAccessIdentity = new aws_cloudfront_1.OriginAccessIdentity(this, 'OriginAccessIdentity', {
            comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
        });
        bucket.grantRead(originAccessIdentity.grantPrincipal);
        if (!disableUpload) {
            const placeHolderSource = path.join(__dirname, '..', 'website');
            new aws_s3_deployment_1.BucketDeployment(this, 'Deployment', {
                sources: [aws_s3_deployment_1.Source.asset(source || placeHolderSource)],
                destinationBucket: bucket,
                retainOnDelete: removalPolicy === core_1.RemovalPolicy.RETAIN,
            });
        }
        this.s3OriginConfig = {
            originAccessIdentity,
            s3BucketSource: bucket,
        };
    }
}
exports.WebsiteBucket = WebsiteBucket;
//# sourceMappingURL=data:application/json;base64,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