# ✨ Introduction

Ragas is a library that helps you move from "vibe checks" to systematic evaluation loops for your AI applications. It provides tools to supercharge the evaluation of Large Language Model (LLM) applications, enabling you to evaluate your LLM applications with ease and confidence.

## Why Ragas?

Traditional evaluation metrics don't capture what matters for LLM applications. Manual evaluation doesn't scale. Ragas solves this by combining **LLM-driven metrics** with **systematic experimentation** to create a continuous improvement loop.

### Key Features

- **Experiments-first approach**: Evaluate changes consistently with `experiments`. Make changes, run evaluations, observe results, and iterate to improve your LLM application.

- **Ragas Metrics**: Create custom metrics tailored to your specific use case with simple decorators or use our library of [available metrics](./concepts/metrics/available_metrics/index.md). Learn more about [metrics in Ragas](./concepts/metrics/overview/index.md).

- **Easy to integrate**: Built-in dataset management, result tracking, and integration with popular frameworks like LangChain, LlamaIndex, and more.

<div class="grid cards" markdown>
- 🚀 **Get Started**

    Start evaluating in 5 minutes with our quickstart guide.

    [:octicons-arrow-right-24: Get Started](getstarted/quickstart.md)

- 📚 **Core Concepts**

    Understand experiments, metrics, and datasets—the building blocks of effective evaluation.

    [:octicons-arrow-right-24: Core Concepts](./concepts/index.md)

- 🛠️ **How-to Guides**

    Integrate Ragas into your workflow with practical guides for specific use cases.

    [:octicons-arrow-right-24: How-to Guides](./howtos/index.md)

- 📖 **References**

    API documentation and technical details for diving deeper.

    [:octicons-arrow-right-24: References](./references/index.md)

</div>


## Want help improving your AI application using evals?

In the past 2 years, we have seen and helped improve many AI applications using evals.

We are compressing this knowledge into a product to replace vibe checks with eval loops so that you can focus on building great AI applications.

If you want help with improving and scaling up your AI application using evals, 🔗 Book a [slot](https://bit.ly/3EBYq4J) or drop us a line: [founders@vibrantlabs.com](mailto:founders@vibrantlabs.com).

