# 🚀 Get Started

Welcome to Ragas! The Get Started guides will walk you through the fundamentals of working with Ragas. These tutorials assume basic knowledge of Python and building LLM application pipelines.

Before you proceed further, ensure that you have [Ragas installed](./install.md)!

!!! note
    The tutorials provide an overview of what you can accomplish with Ragas and the basic skills needed to utilize it effectively. For an in-depth explanation of the core concepts behind Ragas, check out the [Core Concepts](../concepts/index.md) page. You can also explore the [How-to Guides](../howtos/index.md) for specific applications of Ragas.

If you have any questions about Ragas, feel free to join our [Discord community](../community/index.md) and ask in the `#questions` channel.

## Quickstart

Start here to get up and running with Ragas in minutes:

- [Quick Start: Get Running in 5 Minutes](./quickstart.md) 

## Tutorials

Learn how to evaluate different types of AI applications:

- [Evaluate a prompt](../tutorials/prompt.md) - Test and compare different prompts
- [Evaluate a simple RAG system](../tutorials/rag.md) - Evaluate a RAG application
- [Evaluate an AI Workflow](../tutorials/workflow.md) - Evaluate multi-step workflows
- [Evaluate an AI Agent](../tutorials/agent.md) - Evaluate agentic applications
