# 📚 Core Concepts


<div class="grid cards" markdown>

-   :material-flask-outline:{ .lg .middle } [__Experimentation__](experimentation.md)

    ---

    Learn how to systematically evaluate your AI applications using experiments.

    Track changes, measure improvements, and compare results across different versions of your application.

-   :material-database-export:{ .lg .middle } [__Datasets__](datasets.md)

    ---

    Understand how to create, manage, and use evaluation datasets.

    Learn about dataset structure, storage backends, and best practices for maintaining your test data.

-   ::material-ruler-square:{ .lg .middle } [__Ragas Metrics__](metrics/index.md)

    ---

    Use our library of [available metrics](metrics/available_metrics/index.md) or create [custom metrics](metrics/overview/index.md) tailored to your use case.

    Metrics for evaluating [RAG](metrics/available_metrics/index.md#retrieval-augmented-generation), [Agentic workflows](metrics/available_metrics/index.md#agents-or-tool-use-cases) and [more..](metrics/available_metrics/index.md#list-of-available-metrics).

-   :material-database-plus:{ .lg .middle } [__Test Data Generation__](test_data_generation/index.md)

    ---

    Generate high-quality datasets for comprehensive testing.

    Algorithms for synthesizing data to test [RAG](test_data_generation/rag.md), [Agentic workflows](test_data_generation/agents.md)

</div>
