# Code of Conduct

## Our Commitment

We are committed to providing a welcoming and inclusive environment for all people, regardless of age, body size, caste, disability, ethnicity, gender identity and expression, level of experience, family status, gender, immigration status, level of expertise, national origin, personal appearance, political belief, race, religion, sexual identity and orientation, socioeconomic status, tribe, and veteran status.

We expect all participants in the Ragas community—whether contributing code, providing feedback, reporting issues, participating in discussions, attending events, or engaging in any other capacity—to embody the values of respect, inclusion, and professionalism.

## Our Standards

Examples of behaviour that contributes to creating a positive environment include:

- Using welcoming and inclusive language
- Being respectful of differing opinions, viewpoints, and experiences
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members
- Being patient and understanding with newcomers
- Giving credit to others' work and contributions
- Asking clarifying questions rather than making assumptions

Examples of unacceptable behaviour include:

- Harassment, intimidation, or discrimination of any kind
- Unwelcome sexual attention or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Publishing others' private information without explicit permission (doxing)
- Gatekeeping—deliberately excluding or discouraging participation
- Deliberate disinformation or misinformation
- Other conduct which could reasonably be considered inappropriate in a professional setting
- Sustained disruption of discussions or project activities, including:
  - Spam, off-topic posts, or repeated low-effort comments in issues or discussions
  - Duplicate issues or discussions that have already been reported
  - Cross-posting the same issue or question across multiple channels without justification
  - Deliberately posting controversial or unrelated content to distract from ongoing discussions
- Threats of violence or violent language directed at another person

## Scope

This Code of Conduct applies to all spaces managed by the Ragas project, including:

- GitHub repositories (issues, pull requests, discussions, and code reviews)
- Official communication channels (Discord, Slack, mailing lists, forums)
- Official events and conferences organised by Ragas maintainers
- Any official online or offline event, conference, or gathering representing Ragas

This Code of Conduct also applies to conduct outside of these spaces if it demonstrates a pattern of harassment or is reasonably perceived as affecting the safety or well-being of community members.

The Code of Conduct applies equally to all participants, including maintainers, contributors, sponsors, and community members.

## Reporting Violations

If you experience or witness behaviour that violates this Code of Conduct, please report it by emailing **support@ragas.io**. Include as much detail as you're comfortable sharing, including:

- What happened
- Who was involved
- When it occurred
- Any relevant links or context
- Any witnesses (optional)

All reports will be treated confidentially. We will not disclose the identity of the reporter without their consent, except as necessary for investigation and response.

If the violation involves a member of the Code of Conduct committee, or if you're not comfortable reporting directly to that address, please reach out to a project maintainer directly through alternative means.

## Enforcement

The Ragas project maintainers are responsible for clarifying standards of acceptable behaviour and will take appropriate action in response to violations of this Code of Conduct.

### Our Commitment to Enforcement

We recognise that:

- Not all violations are equally severe
- Context matters
- People can learn and grow
- The goal is to maintain a healthy, inclusive community

### Enforcement Guidelines

The following are examples of how we may respond to violations. Responses will be proportionate to the severity and pattern of behaviour:

1. **Warning**: For minor or first-time violations, a private message explaining the issue and its impact, with an expectation to change behaviour.

2. **Temporary Suspension**: For more serious or repeated violations, temporary removal from community spaces (ranging from hours to weeks) to allow for reflection and de-escalation.

3. **Permanent Removal**: For severe, repeated, or unresolved violations, permanent removal from the project and its community spaces.

4. **Law Enforcement**: In cases involving illegal activity or threats of violence, we may involve law enforcement.

The maintainers may also take action to address behaviour even if no formal complaint has been filed, if they reasonably believe it violates this Code of Conduct.

## Consequences for Violations

Anyone who violates this Code of Conduct may face consequences determined by the Ragas maintainers, including:

- Editing or deletion of comments or contributions
- Removal from the project repository or community spaces
- Temporary or permanent ban from participating in Ragas spaces
- Public acknowledgment of the violation (at the discretion of the reporter and maintainers)

## Appeal Process

If you believe you have been unfairly sanctioned under this Code of Conduct, you may appeal by sending a detailed explanation to **support@ragas.io**. The appeal will be reviewed by a different set of maintainers when possible, and a decision will be communicated to you within a reasonable timeframe.

## Attribution

This Code of Conduct is adapted from the Contributor Covenant (https://www.contributor-covenant.org/), and incorporates best practices from codes of conduct in the Python community and other leading open source projects.

## Questions?

If you have questions about this Code of Conduct or how it applies to a specific situation, please reach out to the maintainers at **support@ragas.io** or through a project maintainer you trust.

---

**Last Updated**: November 2024

We appreciate your participation in making Ragas a welcoming and inclusive community for everyone.
