# SwiftDiff

### Authors: Nadine Lee, Li Sun, Alice Cai

## Introduction

SwiftDiff software performs automatic differentiation (AD) for the user. AD is widely used across fields of science, engineering, and mathematics. Because the ability to compute derivates is key to research and applications in these fields, developing and implementing methodologies of AD that operate with speed and precision is crucial to enabling progress. Our AD software, SwiftDiff, sequentially evaluates elementary functions, and avoids the complexity of symbolic differentiation and precision issues of numerical differentiation. By overcoming all the setbacks of both finite difference methods and symbolic derivatives, AD is the most efficient and effective method. The system we present implements multiple methods of AD that compute the derivatives of a function in a single flow with machine precision and accuracy.

## Broader Impact
 
As we worked on this project throughout the semester - we found the development of our project to be highly complex and pragmatic; as we explored and researched the fundamentals of Automatic Differentiation to create our software, we constantly thought to ourselves, wouldn't it be nice if there was a program that did this for us? This is precisely why we created our software - in order to provide a quick, easy, and automated method to calculate complex derivatives, and take advantage of the power of machines. However - this is the very foundation to why softwares like this may need to be more careful and purposeful in its applications. Programming a software to automatically perform differentiation is powerful - yet can take away from learning and education. Students like us - building this software - take a lot away from creating this software; we’ve done heavy research, and manually programmed all the code itself. For future students, who may utilize our software, may not even understand the fundamentals of derivatives, differentiation, etc. Instead of learning the true dynamics of differentiation, they can simply use our software to retrieve derivatives efficiently. Therefore - we highlight that our software be used as a tool, not a shortcut. We believe that our software should be utilized with respect and academic honor.
 
## Inclusivity
 
As a completely woman group, we take immense pride and passion in the notion of inclusivity, both within the details of our software, and the software development field as a whole.  As the developers of AutoDiff, we encourage participation and engagement from all different backgrounds, and fully welcome a global/international reach. As the Python Software Diversity Statement highlights - we hope to embody mutual respect, tolerance, and encouragement within our software, and as developers ourselves. We hope that our software is accessible, and utilized by all different types of users.

To embody this inclusivity - us developers have constantly collaborated and contributed our code with the utmost respect and consideration. Through effective communication, persistently checking in, approving each other's pull requests, endless hours of Zoom calls, and in-person meetings, we have practiced maintaining a code of honesty and respect throughout the development of our software. By doing so - we hope that our users can do the same while interacting with our software. 

We are aware, however, that there are limitations in terms of access to our software - and we hope to contribute to a movement in overcoming these barriers and supporting a more inclusive environment for software development. Although this is a macro problem deeply ingrained in the history and development of computer science, we want to do our best to make sure our software is accessible to all different backgrounds of users. 

For those who find parts of our program to be offensive, we will do our best to re-format our code base and ensure that no sensitive names for classes are used. 

For those who hope to contribute to our program itself, we will leave our emails below to make sure full collaboration and contributions can be made by the community as a whole.

For those who are unable to understand our code through the English language, we will do our best to provide translation scripts and integrate them into our code base in the upcoming months.

For those who weren’t able to receive the education to learn how to code, we will be happy to accommodate a possible time to meet, to allow us to explain what each class, function, etc. does in our software. 
 
For those with disabilities, we hope to integrate additional modules, such as audio modules and Braille modules in the upcoming months. 

Although the automation of our software is complete - we will continuously consider all components of our software and improve it to allow full accessibility and inclusivity.

Thank you so much for utilizing our software, and here are our emails:
Nadine Lee nadine_lee@college.harvard.edu
Li Sun lsun@g.harvard.edu
Alice Cai acai@college.harvard.edu
