"""
    Observatory API

    The REST API for managing and accessing data from the Observatory Platform.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: agent@observatory.academy
    Generated by: https://openapi-generator.tech
"""

import datetime
import unittest

from observatory.api.client.exceptions import ApiAttributeError, ApiTypeError
from observatory.api.client.model.organisation import Organisation
from observatory.api.client.model.telescope import Telescope
from observatory.api.client.model.telescope_type import TelescopeType


class TestTelescope(unittest.TestCase):
    """Telescope unit test stubs"""

    def testTelescope(self):
        """Test Telescope"""

        # Create valid object
        dt = datetime.datetime.utcnow()
        organisation = Organisation(
            id=1,
            name="Curtin",
            gcp_project_id="my-gcp-project",
            gcp_download_bucket="my-download-bucket",
            gcp_transform_bucket="my-transform-bucket",
        )

        Telescope(
            id=1,
            name="Curtin ONIX Telescope",
            organisation=organisation,
            telescope_type=TelescopeType(id=1, name="ONIX Telescope"),
            extra={"view_id": 123456},
        )

        # Read only
        class Configuration:
            def __init__(self):
                self.discard_unknown_keys = True

        self.assertRaises(
            ApiAttributeError,
            Telescope,
            id=1,
            name="Curtin ONIX Telescope",
            organisation=organisation,
            telescope_type=TelescopeType(id=1, name="ONIX Telescope"),
            extra={"view_id": 123456},
            _configuration=Configuration(),
            unknown="var",
            created=dt,
            modified=dt,
        )

        # Invalid argument
        with self.assertRaises(ApiTypeError):
            Telescope("hello")

        # Invalid keyword argument
        with self.assertRaises(ApiAttributeError):
            Telescope(hello="world")

        self.assertRaises(ApiTypeError, Telescope._from_openapi_data, "hello")

        Telescope._from_openapi_data(hello="world", _configuration=Configuration())


if __name__ == "__main__":
    unittest.main()
