"""
    Observatory API

    The REST API for managing and accessing data from the Observatory Platform.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: agent@observatory.academy
    Generated by: https://openapi-generator.tech
"""

import datetime
import unittest

from observatory.api.client.exceptions import ApiAttributeError, ApiTypeError
from observatory.api.client.model.organisation import Organisation


class TestOrganisation(unittest.TestCase):
    """Organisation unit test stubs"""

    def testOrganisation(self):
        """Test Organisation"""

        class Configuration:
            def __init__(self):
                self.discard_unknown_keys = True

        # Create valid object
        dt = datetime.datetime.utcnow()
        Organisation(
            id=1,
            name="Curtin",
            gcp_project_id="my-gcp-project",
            gcp_download_bucket="my-download-bucket",
            gcp_transform_bucket="my-transform-bucket",
            _configuration=Configuration(),
            unknown="var",
        )

        self.assertRaises(
            ApiAttributeError,
            Organisation,
            id=1,
            name="Curtin",
            gcp_project_id="my-gcp-project",
            gcp_download_bucket="my-download-bucket",
            gcp_transform_bucket="my-transform-bucket",
            created=dt,
            modified=dt,
        )

        # Invalid argument
        with self.assertRaises(ApiTypeError):
            Organisation("hello")

        # Invalid keyword argument
        with self.assertRaises(ApiAttributeError):
            Organisation(hello="world")

        self.assertRaises(ApiTypeError, Organisation._from_openapi_data, "hello")

        Organisation._from_openapi_data(hello="world", _configuration=Configuration())


if __name__ == "__main__":
    unittest.main()
