"""
    Observatory API

    The REST API for managing and accessing data from the Observatory Platform.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: agent@observatory.academy
    Generated by: https://openapi-generator.tech
"""

import datetime
import unittest

from observatory.api.client.exceptions import ApiAttributeError, ApiTypeError
from observatory.api.client.model.dataset import Dataset
from observatory.api.client.model.dataset_storage import DatasetStorage

globals()["Dataset"] = Dataset


class TestDatasetStorage(unittest.TestCase):
    """DatasetStorage unit test stubs"""

    def testDatasetStorage(self):
        """Test DatasetStorage"""

        class Configuration:
            def __init__(self):
                self.discard_unknown_keys = True

        dataset = Dataset(
            id=1,
            name="name",
            extra={},
        )

        # Create valid object
        dt = datetime.datetime.utcnow()
        DatasetStorage(
            id=1,
            service="bigquery",
            address="project.dataset.table",
            extra={},
            dataset=dataset,
            _configuration=Configuration(),
            unknown="var",
        )

        self.assertRaises(
            ApiAttributeError,
            DatasetStorage,
            id=1,
            service="bigquery",
            address="project.dataset.table",
            extra={},
            dataset=dataset,
            created=dt,
            modified=dt,
        )

        # Invalid argument
        with self.assertRaises(ApiTypeError):
            DatasetStorage("hello")

        # Invalid keyword argument
        with self.assertRaises(ApiAttributeError):
            DatasetStorage(hello="world")

        self.assertRaises(ApiTypeError, DatasetStorage._from_openapi_data, "hello")

        DatasetStorage._from_openapi_data(hello="world", _configuration=Configuration())


if __name__ == "__main__":
    unittest.main()
