"""
    Observatory API

    The REST API for managing and accessing data from the Observatory Platform.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: agent@observatory.academy
    Generated by: https://openapi-generator.tech
"""

import datetime
import unittest

from observatory.api.client.exceptions import ApiAttributeError, ApiTypeError
from observatory.api.client.model.dataset import Dataset
from observatory.api.client.model.dataset_release import DatasetRelease
from observatory.api.client.model.dataset_storage import DatasetStorage
from observatory.api.client.model.organisation import Organisation
from observatory.api.client.model.telescope import Telescope
from observatory.api.client.model.telescope_type import TelescopeType

globals()["DatasetRelease"] = DatasetRelease
globals()["DatasetStorage"] = DatasetStorage


class TestDataset(unittest.TestCase):
    """Dataset unit test stubs"""

    def testDataset(self):
        """Test Dataset"""

        class Configuration:
            def __init__(self):
                self.discard_unknown_keys = True

        dt = datetime.datetime.utcnow()
        organisation = Organisation(
            id=1,
            name="Curtin",
            gcp_project_id="my-gcp-project",
            gcp_download_bucket="my-download-bucket",
            gcp_transform_bucket="my-transform-bucket",
        )

        connection = Telescope(
            id=1,
            name="Curtin ONIX Telescope",
            organisation=organisation,
            telescope_type=TelescopeType(id=1, name="ONIX Telescope"),
            extra={"view_id": 123456},
        )

        dt = datetime.datetime.utcnow()
        Dataset(
            id=1,
            name="name",
            connection=connection,
            extra={},
            _configuration=Configuration(),
            unknown="var",
        )

        self.assertRaises(
            ApiAttributeError,
            Dataset,
            id=1,
            name="name",
            connection=connection,
            extra={},
            _configuration=Configuration(),
            unknown="var",
            created=dt,
            modified=dt,
        )

        # Invalid argument
        with self.assertRaises(ApiTypeError):
            Dataset("hello")

        # Invalid keyword argument
        with self.assertRaises(ApiAttributeError):
            Dataset(hello="world")

        self.assertRaises(ApiTypeError, Dataset._from_openapi_data, "hello")

        Dataset._from_openapi_data(hello="world", _configuration=Configuration())


if __name__ == "__main__":
    unittest.main()
