"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * A Key Group configuration
 *
 * @resource AWS::CloudFront::KeyGroup
 */
class KeyGroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_KeyGroupProps(props);
        const resource = new cloudfront_generated_1.CfnKeyGroup(this, 'Resource', {
            keyGroupConfig: {
                name: (_b = props.keyGroupName) !== null && _b !== void 0 ? _b : this.generateName(),
                comment: props.comment,
                items: props.items.map(key => key.publicKeyId),
            },
        });
        this.keyGroupId = resource.ref;
    }
    /** Imports a Key Group from its id. */
    static fromKeyGroupId(scope, id, keyGroupId) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.keyGroupId = keyGroupId;
            }
        }(scope, id);
    }
    generateName() {
        const name = core_1.Names.uniqueId(this);
        if (name.length > 80) {
            return name.substring(0, 40) + name.substring(name.length - 40);
        }
        return name;
    }
}
exports.KeyGroup = KeyGroup;
_a = JSII_RTTI_SYMBOL_1;
KeyGroup[_a] = { fqn: "@aws-cdk/aws-cloudfront.KeyGroup", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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