# Generated by Django 2.0.4 on 2018-12-13 12:39

from django.db import migrations


def switch_namespace_field(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    Namespace = apps.get_model('tradukoj', 'Namespace')
    TranslationKey = apps.get_model('tradukoj', 'TranslationKey')
    namespace, _created = Namespace.objects.get_or_create(text='global')
    for tranlsation_key in TranslationKey.objects.all():
        tranlsation_key.new_namespace = namespace
        tranlsation_key.text = "{0}.{1}".format(tranlsation_key.namespace,
                                                tranlsation_key.text)
        tranlsation_key.save()


class Migration(migrations.Migration):

    dependencies = [
        ('tradukoj', '0008_auto_20181213_1238'),
    ]

    operations = [
        migrations.RunPython(switch_namespace_field),
    ]
