/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.support.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;

public class WhitelistedObjectInputStream
extends ObjectInputStream {
    private final Collection<String> m_allowedTypes;

    public WhitelistedObjectInputStream(InputStream inputStream, Collection<String> collection) throws IOException {
        super(inputStream);
        this.m_allowedTypes = collection;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (!this.allowedToDeserialize(objectStreamClass.getName())) {
            throw new RuntimeException(String.format("InputStream contained serialized %s, no instances of which have been serialized by the associated TypeRecordingObjectOutputStream instance!", objectStreamClass.getName()));
        }
        return super.resolveClass(objectStreamClass);
    }

    private boolean allowedToDeserialize(String string) {
        return this.isPrimitiveTypeOrArrayOfPrimitive(string) || this.m_allowedTypes.contains(string);
    }

    private boolean isPrimitiveTypeOrArrayOfPrimitive(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '['; ++n) {
        }
        if (n != string.length() - 1) {
            assert (n > 0 == (string.charAt(n) == 'L'));
            return false;
        }
        assert ("ZBCDFIJS".indexOf(string.charAt(string.length() - 1)) >= 0);
        return true;
    }
}

