/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.client.util.Data;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.dataengine.BQHTParser;
import com.simba.googlebigquery.googlebigquery.dataengine.IBQDataHandler;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class BQHTDataHandler
implements IBQDataHandler {
    private final BQBufferManager m_bufferManager;
    private final List<ColumnMetadata> m_columnMetadata;
    private final ILogger m_logger;
    private GenericRecord m_row;

    public BQHTDataHandler(BQBufferManager bQBufferManager, List<ColumnMetadata> list, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_bufferManager = bQBufferManager;
        this.m_columnMetadata = list;
        this.m_logger = iLogger;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        this.m_row = this.m_bufferManager.getNextRow();
        if (null == this.m_row) {
            this.m_bufferManager.stop();
            return false;
        }
        return true;
    }

    @Override
    public boolean retrieveData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        BQColumnMetadata bQColumnMetadata = (BQColumnMetadata)this.m_columnMetadata.get(n);
        short s = bQColumnMetadata.getTypeMetadata().getType();
        Object object = this.m_row.get(bQColumnMetadata.getName());
        if (null == object || Data.isNull((Object)object)) {
            dataWrapper.setNull(s);
            return false;
        }
        if (bQColumnMetadata.isRepeated()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = BQHTParser.avroToString(this.m_logger, object, Schema.Type.ARRAY, stringBuilder, this.m_row.getSchema().getField(bQColumnMetadata.getName()).schema().getElementType().getLogicalType(), null, n, this.m_columnMetadata);
            return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
        }
        if (bQColumnMetadata.isRecord()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = BQHTParser.avroToString(this.m_logger, object, Schema.Type.RECORD, stringBuilder, null, null, n, this.m_columnMetadata);
            return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
        }
        return BQHTParser.getDataHTAPI(s, bQColumnMetadata.getTypeMetadata(), l, l2, dataWrapper, object, this.m_row.getSchema().getField(bQColumnMetadata.getName()), this.m_logger);
    }
}

