/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.IntervalConverter;
import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITimeSpan;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.exceptions.ConversionFailed;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class TimeSpanJDBCDataSink
extends ConvertingJDBCDataSink {
    private final int m_sqlType;
    private final int m_leadingFieldPrecision;
    private final int m_fractionalSecondsPrecision;

    public TimeSpanJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_sqlType = typeMetadata.getType();
        switch (this.m_sqlType) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SQL type " + this.m_sqlType);
            }
        }
        this.m_leadingFieldPrecision = typeMetadata.getIntervalPrecision();
        this.m_fractionalSecondsPrecision = typeMetadata.getPrecision();
        assert (this.m_leadingFieldPrecision > 0 && this.m_leadingFieldPrecision <= 9);
        assert (this.m_fractionalSecondsPrecision >= 0 && this.m_fractionalSecondsPrecision <= 9);
    }

    @Override
    protected IntervalConverter getIntervalConverter() {
        return IntervalConverter.INSTANCE;
    }

    protected final int getSqlType() {
        return this.m_sqlType;
    }

    protected final int getLeadingFieldPrecision() {
        return this.m_leadingFieldPrecision;
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fractionalSecondsPrecision;
    }

    protected final void handleConversionResult(Object object, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected abstract void doSet(DSITimeSpan var1) throws ErrorException, ConversionFailed;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException, ConversionFailed {
        if (object == null) {
            this.doSet(null);
        } else if (object instanceof DSITimeSpan) {
            DSITimeSpan dSITimeSpan = this.getIntervalConverter().normalize((DSITimeSpan)object, this.m_sqlType, this.m_leadingFieldPrecision, this.m_fractionalSecondsPrecision, this.getWarningListener(), this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(dSITimeSpan);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            DSITimeSpan dSITimeSpan = NonTrivialJDBCConversions.stringToTimeSpan(string, this.m_sqlType, this.getIntervalConverter(), this.m_leadingFieldPrecision, this.m_fractionalSecondsPrecision, this.getWarningListener(), this.getAndClearListener());
            this.handleConversionResult(string, "set");
            this.doSet(dSITimeSpan);
        }
    }
}

